/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: HTTPResponseCodeAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.7 $
 * Last Modified: $Date: 2005/08/01 15:44:08 $
 *****************************************************************************/
package org.ten60.transport.http.response.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.PairList;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.transport.http.response.representation.*;

import org.ten60.netkernel.layer1.representation.ByteArrayAspect;
import org.ten60.netkernel.layer1.representation.MultiPartAspect;
import org.ten60.netkernel.layer1.representation.MonoRepresentationImpl;
import org.ten60.netkernel.layer1.meta.*;
import java.util.*;

/**
 * Creates a ResponseCodeAspect.  If the operand exists
 * it is placed in a multipart representation and a
 * HTTP Response Code aspect is added.  Otherwise just a response code
 * is returned.  The response code is defined by the parameter doc
 * @author  pjr
 */
public class HTTPResponseCodeAccessor extends XAccessor
{
	
	/** Creates a new instance of HTTPResponseCodeAccessor */
	public HTTPResponseCodeAccessor()
	{	declareArgument(OPERAND, false, false);
		declareArgument(PARAMETER, true, false);
		declareThreadSafe();
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	IURRepresentation paramRep = aHelper.getParameter(IURAspect.class);
		IXDAReadOnly param = aHelper.getParameter().getXDA();
		int code=Integer.parseInt(param.getText("/HTTPResponseCode/code", true));
		String reason=null;
		if(param.isTrue("/HTTPResponseCode/reason"))
		{	reason= param.getText("/HTTPResponseCode/reason", true);
		}
		IXDAReadOnlyIterator it=param.readOnlyIterator("/HTTPResponseCode/header");
		PairList headers = new PairList(8);
		while(it.hasNext())
		{	it.next();
			String name = it.getText("name",true);
			String value =  it.getText("value",true);
			headers.put(name,value);
		}
		ResponseCodeAspect rca = new ResponseCodeAspect(code,reason,headers);
		DependencyMeta meta = new DependencyMeta(ResponseCodeAspect.MIME,2,0);
		meta.setDependencies(Collections.singletonList(paramRep.getMeta()),null);
		IURRepresentation responseCodeRep = new MonoRepresentationImpl(meta,rca);
		IURRepresentation result=null;
		HashMap parts=new HashMap(1);
		parts.put("responseCode",responseCodeRep);
		if(aHelper.hasOperand()) 
		{	result=MultiPartAspect.create(aHelper.getOperand(IAspectBinaryStream.class),parts);
		}
		else
		{	IURAspect aspect = new ByteArrayAspect(new byte[0]);
			IURRepresentation primary = new MonoRepresentationImpl(meta,aspect);
			result=MultiPartAspect.create(primary,parts);
		}
		return result;
	}
}