/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Utils {
    public static URL getResource(String aPath, String aBasePath, ClassLoader aClassLoader) {
        URL result = null;
        File f = new File(aBasePath, aPath);
        if (f.exists()) {
            try {
                result = new URL(f.toURI().toString());
            }
            catch (MalformedURLException e) {}
        } else {
            if (aPath.charAt(0) == '/') {
                aPath = aPath.substring(1);
            }
            result = aClassLoader.getResource(aPath);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream aInput, OutputStream aOutput) throws IOException {
        byte[] b = new byte[256];
        try {
            int c;
            while ((c = aInput.read(b)) > 0) {
                aOutput.write(b, 0, c);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                aInput.close();
            }
            finally {
                aOutput.close();
            }
            throw throwable;
        }
        try {
            aInput.close();
        }
        finally {
            aOutput.close();
        }
    }

    public static String fixSlash(String aURI) {
        return aURI.replace('\\', '/');
    }

    public static void appendUnreservedURIChar(StringBuffer sb, String aURI) {
        int length = aURI.length();
        for (int i = 0; i < length; ++i) {
            char c = aURI.charAt(i);
            if (c == '/' || c == '-' || c == '.' || c == '_' || c == '~' || Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            sb.append(Integer.toHexString(c));
        }
    }

    public static String decode(String aInput) {
        StringBuffer sb = new StringBuffer(aInput.length());
        int length = aInput.length();
        for (int i = 0; i < length; ++i) {
            char c = aInput.charAt(i);
            if (c == '%') {
                int c1 = Utils.toHex(aInput.charAt(++i));
                int c2 = Utils.toHex(aInput.charAt(++i));
                c = (char)((c1 << 4) + c2);
            }
            sb.append(c);
        }
        return new String(sb);
    }

    private static int toHex(char aChar) {
        int result = 0;
        if (aChar <= '9' && aChar >= '0') {
            result = aChar - 48;
        } else if (aChar <= 'Z' && aChar >= 'A') {
            result = aChar - 55;
        }
        return result;
    }
}

