/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SysLogger {
    private static Logger logger;
    private static List sPermanentHandlers;
    public static final char NEWLINE_SUBSTITUTE = '\u0011';
    public static final boolean logMethods = true;
    private static boolean[] mLogLevelEnable;
    private static Map sMap;
    public static final int FINE = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int SEVERE = 3;
    public static final int DEBUG = 4;
    public static final int APPLICATION = 5;
    public static final int CONTAINER = 6;
    public static final int CACHE = 7;
    private static int sSevere;
    private static int sWarning;

    private SysLogger() {
    }

    public static boolean shouldLog(int level, Object callingObject) {
        return SysLogger.logCheck(level, callingObject);
    }

    private static boolean logCheck(int level, Object callingObject) {
        boolean logIt = mLogLevelEnable[level];
        return logIt;
    }

    public static void addHandler(Handler h) {
        h.setLevel(Level.ALL);
        logger.addHandler(h);
    }

    public static void addPermanentHandler(Handler h) {
        h.setLevel(Level.ALL);
        sPermanentHandlers.add(h);
        logger.addHandler(h);
    }

    public static Handler getHandler(String classname) {
        Handler[] h = logger.getHandlers();
        for (int i = 0; i < h.length; ++i) {
            if (!h[i].getClass().getName().equals(classname)) continue;
            return h[i];
        }
        return null;
    }

    public static void setLoggingFor(int level, boolean on) {
        SysLogger.mLogLevelEnable[level] = on;
        Level l = Level.ALL;
        if (mLogLevelEnable[4]) {
            l = Level.ALL;
        } else if (mLogLevelEnable[7]) {
            l = Level.ALL;
        } else if (mLogLevelEnable[0]) {
            l = Level.FINE;
        } else if (mLogLevelEnable[1]) {
            l = Level.INFO;
        } else if (mLogLevelEnable[5]) {
            l = Level.INFO;
        } else if (mLogLevelEnable[6]) {
            l = Level.INFO;
        } else if (mLogLevelEnable[2]) {
            l = Level.WARNING;
        } else if (mLogLevelEnable[3]) {
            l = Level.SEVERE;
        }
        logger.setLevel(l);
    }

    public static void resetHandlers() {
        Handler[] h = logger.getHandlers();
        for (int i = 0; i < h.length; ++i) {
            logger.removeHandler(h[i]);
        }
        Iterator i = sPermanentHandlers.iterator();
        while (i.hasNext()) {
            Handler handler = (Handler)i.next();
            logger.addHandler(handler);
        }
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
    }

    private static String getCallingMethod(Object callingObject) {
        int i;
        int j;
        String name = callingObject.getClass().getName();
        String method = null;
        int index = name.lastIndexOf(46);
        String pkgName = name.substring(0, index);
        Exception e = new Exception();
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String str = sw.toString();
        for (j = i = str.indexOf(40, str.indexOf(40) + 1); str.charAt(j) != '.' && j > 0; --j) {
        }
        method = str.substring(j + 1, i);
        return method;
    }

    public static void log1(int level, Object callingObject, String msg, Object p1) {
        StringBuffer buf = new StringBuffer(msg);
        SysLogger.replaceParameter(buf, 1, p1);
        SysLogger.log(level, callingObject, buf.toString());
    }

    public static void log2(int level, Object callingObject, String msg, Object p1, Object p2) {
        StringBuffer buf = new StringBuffer(msg);
        SysLogger.replaceParameter(buf, 1, p1);
        SysLogger.replaceParameter(buf, 2, p2);
        SysLogger.log(level, callingObject, buf.toString());
    }

    public static void log3(int level, Object callingObject, String msg, Object p1, Object p2, Object p3) {
        StringBuffer buf = new StringBuffer(msg);
        SysLogger.replaceParameter(buf, 1, p1);
        SysLogger.replaceParameter(buf, 2, p2);
        SysLogger.replaceParameter(buf, 3, p3);
        SysLogger.log(level, callingObject, buf.toString());
    }

    public static void log4(int level, Object callingObject, String msg, Object p1, Object p2, Object p3, Object p4) {
        StringBuffer buf = new StringBuffer(msg);
        SysLogger.replaceParameter(buf, 1, p1);
        SysLogger.replaceParameter(buf, 2, p2);
        SysLogger.replaceParameter(buf, 3, p3);
        SysLogger.replaceParameter(buf, 4, p4);
        SysLogger.log(level, callingObject, buf.toString());
    }

    private static void replaceParameter(StringBuffer buf, int i, Object value) {
        String param = "%" + i;
        int k = buf.indexOf(param);
        if (k >= 0) {
            if (value != null) {
                buf.replace(k, k + param.length(), value.toString());
            } else {
                buf.replace(k, k + param.length(), "<null>");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(int level, Object callingObject, String _msg) {
        if (!SysLogger.logCheck(level, callingObject)) {
            return;
        }
        _msg = _msg.replace('\n', '\u0011');
        String className = callingObject.getClass().getName();
        String methodName = null;
        methodName = SysLogger.getCallingMethod(callingObject);
        Logger logger = SysLogger.logger;
        synchronized (logger) {
            switch (level) {
                case 0: 
                case 4: 
                case 7: {
                    SysLogger.logger.logp(Level.FINE, className, methodName, _msg);
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    SysLogger.logger.logp(Level.INFO, className, methodName, _msg);
                    break;
                }
                case 2: {
                    SysLogger.logger.logp(Level.WARNING, className, methodName, _msg);
                    ++sWarning;
                    break;
                }
                case 3: {
                    SysLogger.logger.logp(Level.SEVERE, className, methodName, _msg);
                    ++sSevere;
                    break;
                }
                default: {
                    SysLogger.logger.logp(Level.INFO, className, methodName, "Attempting to log invalid type");
                }
            }
        }
    }

    public static void config(XMLReadable config) {
        SysLogger.resetHandlers();
        try {
            List n = config.getNodes("/system/log/handler");
            Iterator i = n.iterator();
            while (i.hasNext()) {
                XMLReadable xr = new XMLReadable((Node)i.next());
                String classname = "";
                try {
                    classname = xr.getText("handlerClass");
                    Class<?> c = Class.forName(classname);
                    Handler h = (Handler)c.newInstance();
                    h.setLevel(Level.ALL);
                    classname = xr.getText("formatterClass");
                    if (!classname.equals("")) {
                        c = Class.forName(classname);
                        Formatter f = (Formatter)c.newInstance();
                        h.setFormatter(f);
                    }
                    SysLogger.addHandler(h);
                }
                catch (Throwable e) {
                    System.err.println("LOG handler " + classname + " couldn't be loaded");
                }
            }
            SysLogger.resetLevels();
            n = config.getNodes("/system/log/level");
            Node parent = (Node)n.get(0);
            Element l = XMLUtils.getFirstChildElement(parent);
            while (l != null) {
                String id = l.getNodeName();
                Integer level = (Integer)sMap.get(id);
                SysLogger.setLoggingFor(level, true);
                l = XMLUtils.getNextSiblingElement(l);
            }
        }
        catch (Exception e) {
            System.err.println("Problem configuring Loggers");
            e.printStackTrace();
        }
    }

    public static void resetStats() {
        sSevere = 0;
        sWarning = 0;
    }

    private static void resetLevels() {
        SysLogger.setLoggingFor(4, false);
        SysLogger.setLoggingFor(0, false);
        SysLogger.setLoggingFor(1, false);
        SysLogger.setLoggingFor(2, false);
        SysLogger.setLoggingFor(3, false);
        SysLogger.setLoggingFor(5, false);
        SysLogger.setLoggingFor(6, false);
        SysLogger.setLoggingFor(7, false);
    }

    public static int getErrorCount() {
        return sSevere;
    }

    public static int getWarningCount() {
        return sWarning;
    }

    static {
        sPermanentHandlers = Collections.synchronizedList(new ArrayList());
        mLogLevelEnable = new boolean[8];
        sMap = new HashMap(7);
        sMap.put("debug", new Integer(4));
        sMap.put("fine", new Integer(0));
        sMap.put("info", new Integer(1));
        sMap.put("warning", new Integer(2));
        sMap.put("severe", new Integer(3));
        sMap.put("application", new Integer(5));
        sMap.put("container", new Integer(6));
        sMap.put("cache", new Integer(7));
        LogManager manager = LogManager.getLogManager();
        try {
            manager.readConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger = Logger.getLogger("com.ten60.netkernel.util.SysLogger");
        SysLogger.resetHandlers();
        sSevere = 0;
        sWarning = 0;
    }
}

