/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import com.ten60.netkernel.util.IXMLException;
import com.ten60.netkernel.util.XMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;

public class NetKernelException
extends Exception
implements IXMLException {
    private static int sTraceDepth = 4;
    private String mId;
    private String mRequestId;
    private ArrayList mCauses = null;

    public NetKernelException(String aMessage) {
        super(aMessage);
    }

    public NetKernelException(String aId, String aMessage, String aRequestId) {
        super(aMessage);
        this.mId = aId;
        this.mRequestId = aRequestId;
    }

    public String getId() {
        return this.mId;
    }

    public void addCause(Throwable aThrowable) {
        if (this.mCauses == null) {
            this.mCauses = new ArrayList(4);
        }
        this.mCauses.add(aThrowable);
    }

    public String getDeepestId() {
        Iterator i;
        String result = null;
        if (this.mCauses != null && (i = this.mCauses.iterator()).hasNext()) {
            Throwable t = (Throwable)i.next();
            result = t instanceof NetKernelException ? ((NetKernelException)t).getDeepestId() : t.getClass().getName();
        }
        if (result == null) {
            result = this.getId();
        }
        return result;
    }

    public void appendXML(Writer aWriter) throws IOException {
        aWriter.write("<ex>");
        if (this.mId != null) {
            XMLUtils.write(aWriter, "id", this.mId);
        } else {
            XMLUtils.write(aWriter, "id", this.getClass().getName());
        }
        if (this.getMessage() != null) {
            XMLUtils.write(aWriter, "message", XMLUtils.escape(this.getMessage()));
        }
        if (this.mRequestId != null) {
            XMLUtils.write(aWriter, "requestid", XMLUtils.escape(this.mRequestId));
        }
        NetKernelException.writeStack(this, aWriter);
        if (this.mCauses != null) {
            for (int i = 0; i < this.mCauses.size(); ++i) {
                Throwable t = (Throwable)this.mCauses.get(i);
                if (t instanceof IXMLException) {
                    ((IXMLException)((Object)t)).appendXML(aWriter);
                    continue;
                }
                NetKernelException.writeThrowable(t, aWriter);
            }
        }
        aWriter.write("</ex>");
    }

    static void writeThrowable(Throwable aThrowable, Writer aWriter) throws IOException {
        aWriter.write("<ex>");
        XMLUtils.write(aWriter, "id", aThrowable.getClass().getName());
        if (aThrowable.getMessage() != null) {
            XMLUtils.write(aWriter, "message", XMLUtils.escape(aThrowable.getMessage()));
        }
        NetKernelException.writeStack(aThrowable, aWriter);
        Throwable cause = aThrowable.getCause();
        if (cause != null) {
            if (cause instanceof IXMLException) {
                ((IXMLException)((Object)cause)).appendXML(aWriter);
            } else {
                NetKernelException.writeThrowable(cause, aWriter);
            }
        }
        aWriter.write("</ex>");
    }

    static void writeStack(Throwable aThrowable, Writer aWriter) throws IOException {
        aWriter.write("<stack>");
        StackTraceElement[] trace = aThrowable.getStackTrace();
        for (int i = 0; i < sTraceDepth && i < trace.length; ++i) {
            StackTraceElement ste = trace[i];
            String message = ste.getClassName() + '.' + XMLUtils.escape(ste.getMethodName()) + "() line:" + Integer.toString(ste.getLineNumber());
            XMLUtils.write(aWriter, "level", message);
        }
        aWriter.write("</stack>");
    }

    public String toString() {
        StringWriter sw = new StringWriter(1024);
        try {
            this.appendXML(sw);
            System.out.println(sw.toString());
            Document d = XMLUtils.parse(new StringReader(sw.toString()));
            return XMLUtils.getInstance().toXML(d, true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(sw);
            return "";
        }
    }

    public static void setTraceDepth(int aDepth) {
        sTraceDepth = aDepth;
    }

    public Throwable getCause() {
        Throwable result = null;
        if (this.mCauses != null) {
            result = (Throwable)this.mCauses.get(0);
        }
        return result;
    }
}

