/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.module.MappingDebug;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.util.IXMLException;
import com.ten60.netkernel.util.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class NoAccessorFoundException
extends Exception
implements IXMLException {
    private List mDebugList;
    private URIdentifier mRequest;
    private URIdentifier mModule;

    public NoAccessorFoundException(URIdentifier aRequest, URIdentifier aModule, List aDebugList) {
        this.mDebugList = aDebugList;
        this.mRequest = aRequest;
        this.mModule = aModule;
    }

    public void appendXML(Writer aWriter) throws IOException {
        aWriter.write("<ex>");
        this.write("id", this.getDeepestId(), aWriter, false);
        this.write("message", "The request " + XMLUtils.escape(this.mRequest.toString()) + " in module " + XMLUtils.escape(this.mModule.toString()) + " failed because no module could be located to handle it. See Exception trace for details of resolution process.", aWriter, false);
        this.write("requestid", this.mRequest.toString(), aWriter, true);
        aWriter.write("<trace>");
        Iterator i = this.mDebugList.iterator();
        while (i.hasNext()) {
            MappingDebug debug = (MappingDebug)i.next();
            this.write("step", debug.toString(), aWriter, true);
        }
        aWriter.write("</trace>");
        aWriter.write("</ex>");
    }

    public String getDeepestId() {
        return "URI Resolution Failure";
    }

    private void write(String aName, String aText, Writer aWriter, boolean aEscape) throws IOException {
        aWriter.write(60);
        aWriter.write(aName);
        aWriter.write(62);
        if (aEscape) {
            aWriter.write(XMLUtils.escape(aText));
        } else {
            aWriter.write(aText);
        }
        aWriter.write("</");
        aWriter.write(aName);
        aWriter.write(62);
    }
}

