/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module;

import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class ModuleFactory {
    private Map mModules = new HashMap();
    private Set mUsedModules = new HashSet();
    private Set mNewModules = new HashSet();

    public ModuleDefinition getModuleFor(String aModuleURIString, ModuleManager aManager) throws Exception {
        URL moduleConfig = new URL(aModuleURIString + "module.xml");
        URLConnection c = moduleConfig.openConnection();
        InputStream is = c.getInputStream();
        Document d = XMLUtils.parse(is);
        XMLReadable readable = new XMLReadable(d);
        String uri = readable.getText("module/identity/uri");
        String version = readable.getText("module/identity/version");
        String key = uri + version;
        if (this.mUsedModules.contains(key)) {
            throw new NetKernelException("Duplicate Module");
        }
        ModuleDefinition md = (ModuleDefinition)this.mModules.get(key);
        long timestamp = c.getLastModified();
        if (md == null || md.getTimestamp() < timestamp) {
            md = new ModuleDefinition(aModuleURIString, timestamp, d, aManager);
            this.mModules.put(key, md);
            this.mNewModules.add(key);
        }
        this.mUsedModules.add(key);
        return md;
    }

    public void complete() {
        boolean noChanges = true;
        Iterator i = this.mModules.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            ModuleDefinition md = (ModuleDefinition)entry.getValue();
            String message = null;
            if (!this.mUsedModules.contains(key)) {
                message = "Decommissioning";
                i.remove();
                md.cleanup();
                noChanges = false;
            } else if (this.mNewModules.contains(key)) {
                message = "Commissioning";
                noChanges = false;
            }
            if (message == null) continue;
            SysLogger.log3(6, this, "  %1 module [%2 v%3]", message, md.getURI().toString(), md.getVersion().toString(3));
        }
        if (noChanges) {
            SysLogger.log(1, this, "No changes in module configuration detected");
        }
        this.mUsedModules.clear();
        this.mNewModules.clear();
    }
}

