/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module;

import com.ten60.netkernel.cache.Cache;
import com.ten60.netkernel.cache.ICachelet;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleClassLoader;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.module.URIMapping;
import com.ten60.netkernel.module.rewrite.RegexRewriterMaplet;
import com.ten60.netkernel.module.rewrite.RegexRewriterRule;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.fragment.IFragmentor;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urrequest.IRequestorContext;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.PairList;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.Utils;
import com.ten60.netkernel.util.Version;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ModuleDefinition
implements IRequestorContext {
    public static final String ELEMENT_IMPORT = "import";
    public static final String ELEMENT_ACCESSOR = "ura";
    public static final String ELEMENT_THIS = "this";
    public static final String ELEMENT_SUPER = "super";
    public static final String ELEMENT_REWRITE = "rewrite";
    public static final String ELEMENT_SKIP = "skip";
    public static final String ELEMENT_VALIDATION_ERROR = "validation-error";
    public static final String MODULE_CONFIG = "module.xml";
    private Document mDoc;
    private String mURIString;
    private Version mVersion;
    private XMLReadable mReadable;
    private ModuleClassLoader mClassLoader;
    private URIdentifier mURI;
    private URIMapping[] mURIMappingsArray;
    private URIMapping mExportedURIMatches;
    private List mExportedClasses;
    private List mTransreptors;
    private List mFragmentors;
    private List mImportedModules;
    private RegexRewriterMaplet mRewriter;
    private ICachelet mCache;
    private PairList mResourceExpirys;
    private String mScratchDir;
    private String mScratchDirURI;
    private boolean mEditable;
    private long mTimestamp;

    public ModuleDefinition(String aModuleURIString, long aTimestamp, Document aDoc, ModuleManager aModuleManager) throws IOException, SAXException, MalformedURLException, ClassNotFoundException, NetKernelException {
        this.mURIString = aModuleURIString;
        this.mDoc = aDoc;
        this.mReadable = new XMLReadable(this.mDoc);
        this.mURI = new URIdentifier(this.mReadable.getText("module/identity/uri"));
        this.mVersion = new Version(this.mReadable.getText("module/identity/version"));
        this.mRewriter = new RegexRewriterMaplet();
        this.mRewriter.configure(this.mReadable.getNodes("module/rewrite/rule"));
        this.mImportedModules = new ArrayList();
        this.mResourceExpirys = new PairList(4);
        this.mClassLoader = this.createClassLoader(this.mURIString, aModuleManager);
        if (aModuleURIString.startsWith("file:")) {
            String configURI = aModuleURIString + MODULE_CONFIG;
            File f = new File(URI.create(configURI));
            this.mEditable = f.canWrite();
        }
        this.mTimestamp = aTimestamp;
    }

    public void cleanup() {
        this.mCache = null;
        this.mClassLoader.cleanup();
        this.mClassLoader = null;
        this.mTransreptors = null;
        this.mFragmentors = null;
        this.mImportedModules = null;
        this.mDoc = null;
        this.mURIMappingsArray = null;
    }

    public String getSourceURI() {
        return this.mURIString;
    }

    public ICachelet getCache() {
        return this.mCache;
    }

    public String getScratchDir() {
        return this.mScratchDir;
    }

    public String getScratchDirURI() {
        return this.mScratchDirURI;
    }

    public URL getResource(String aPath) {
        return Utils.getResource(aPath, this.mScratchDir, this.mClassLoader);
    }

    public boolean isExpanded() {
        return this.mURIString.endsWith("/");
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    private void buildScratchDir(Container aContainer) throws IOException {
        String uriString = this.mURIString;
        if (uriString.endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        if (uriString.startsWith("jar:")) {
            uriString = uriString.substring(4, uriString.length() - (1 + ".xar".length()));
        }
        URI uri1 = URI.create(uriString);
        URI uri2 = new File(aContainer.getBasePath()).toURI();
        URI uri3 = uri2.relativize(uri1);
        StringBuffer sb = new StringBuffer(uri3.toString());
        for (int i = sb.length() - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            sb.setCharAt(i, '_');
        }
        File scratchDir = new File(aContainer.getScratchPath(), sb.toString());
        scratchDir.mkdirs();
        this.mScratchDir = Utils.fixSlash(scratchDir.getCanonicalPath() + "/");
        this.mScratchDirURI = File.separatorChar == '/' ? "file:" + this.mScratchDir : "file:///" + this.mScratchDir;
        this.mScratchDirURI = this.mScratchDirURI.replaceAll(" ", "%20");
    }

    void parseMappings(ModuleManager aModuleManager, Container aContainer) throws Exception {
        Object mapping;
        this.buildScratchDir(aContainer);
        ArrayList<URIMapping> URIMappings = new ArrayList<URIMapping>();
        List mappings = this.getReadable().getNodes("module/mapping/*");
        NetKernelException exception = null;
        this.mClassLoader.reset();
        this.mImportedModules.clear();
        Iterator j = mappings.iterator();
        while (j.hasNext()) {
            try {
                String pattern;
                URIMapping uriMapping;
                URIMapping uriMapping2;
                XMLReadable r;
                mapping = (Node)j.next();
                String nodeName = mapping.getNodeName();
                if (nodeName.equals(ELEMENT_IMPORT)) {
                    ModuleDefinition imported;
                    r = new XMLReadable((Node)mapping);
                    URIdentifier uri = new URIdentifier(r.getText("uri").trim());
                    String minVersionString = r.getText("version-min");
                    String maxVersionString = r.getText("version-max");
                    Version minVersion = minVersionString.length() > 0 ? new Version(minVersionString) : null;
                    Version maxVersion = maxVersionString.length() > 0 ? new Version(maxVersionString) : null;
                    try {
                        imported = aModuleManager.getModule(uri, minVersion, maxVersion);
                    }
                    catch (NetKernelException e) {
                        XMLUtils.appendTextedElement((Node)mapping, ELEMENT_VALIDATION_ERROR, XMLUtils.escape(e.getMessage()));
                        SysLogger.log3(3, this, "Failed to locate import [%1] in module [%2] :%3", uri.toString(), this.mURI.toString(), e.getMessage());
                        throw e;
                    }
                    URIMappings.add(imported.getExportedURIMatches());
                    this.mClassLoader.addImportedModule(imported);
                    this.mImportedModules.add(imported);
                    continue;
                }
                if (nodeName.equals(ELEMENT_ACCESSOR)) {
                    r = new XMLReadable((Node)mapping);
                    String match = r.getText("match");
                    String classString = r.getText("class");
                    uriMapping2 = new URIMapping(match, classString);
                    URIMappings.add(uriMapping2);
                    continue;
                }
                if (nodeName.equals(ELEMENT_THIS)) {
                    r = new XMLReadable((Node)mapping);
                    List matches = r.getTexts("match", true);
                    if (matches.size() == 0) {
                        URIMapping uriMapping3 = new URIMapping("ffcpl:.*", 1);
                        URIMappings.add(uriMapping3);
                    } else {
                        Iterator i = matches.iterator();
                        while (i.hasNext()) {
                            String match = (String)i.next();
                            uriMapping = new URIMapping(match, 1);
                            URIMappings.add(uriMapping);
                        }
                    }
                    List expiries = r.getNodes("expiry");
                    Iterator i = expiries.iterator();
                    while (i.hasNext()) {
                        Node expiry = (Node)i.next();
                        XMLReadable r2 = new XMLReadable(expiry);
                        Matcher matcher = Pattern.compile(r2.getText("match").trim()).matcher("");
                        Long offset = new Long(r2.getText("offset").trim());
                        this.mResourceExpirys.put(matcher, offset);
                    }
                    continue;
                }
                if (nodeName.equals(ELEMENT_SUPER)) {
                    URIMapping uriMapping4 = new URIMapping(".*", 2);
                    URIMappings.add(uriMapping4);
                    continue;
                }
                if (nodeName.equals(ELEMENT_REWRITE)) {
                    r = new XMLReadable((Node)mapping);
                    pattern = r.getText("match").trim();
                    String to = r.getText("to").trim();
                    RegexRewriterRule rrr = new RegexRewriterRule(pattern, to);
                    uriMapping = new URIMapping(rrr);
                    URIMappings.add(uriMapping);
                    continue;
                }
                if (!nodeName.equals(ELEMENT_SKIP)) continue;
                r = new XMLReadable((Node)mapping);
                pattern = r.getText("match").trim();
                int skipCount = Integer.parseInt(r.getText("count").trim());
                uriMapping2 = new URIMapping(skipCount, pattern);
                URIMappings.add(uriMapping2);
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new NetKernelException("failed to parse module", null, this.getURI().toString());
                }
                exception.addCause(e);
                SysLogger.log2(3, this, "Failed to parse mappings in module [%1] : %2", this.mURI.toString(), e.toString());
            }
        }
        this.mURIMappingsArray = new URIMapping[URIMappings.size()];
        for (int i = URIMappings.size() - 1; i >= 0; --i) {
            this.mURIMappingsArray[i] = mapping = (URIMapping)URIMappings.get(i);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public URIMapping[] getMappings() {
        return this.mURIMappingsArray;
    }

    void parseFinal(Container aContainer) throws NetKernelException {
        NetKernelException e2;
        Object instance;
        NetKernelException exception = null;
        String cacheClassString = this.mReadable.getText("module/cache");
        if (cacheClassString.length() > 0) {
            try {
                Class cacheClass = this.mClassLoader.loadClass(cacheClassString);
                this.mCache = (ICachelet)cacheClass.newInstance();
                this.mCache.init(aContainer, this);
                Cache cache = (Cache)aContainer.getComponent(Cache.URI);
                cache.registerCacheletModule(this);
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new NetKernelException("failed to parse module", null, this.getURI().toString());
                }
                NetKernelException nke = new NetKernelException("Failed to initialise cache");
                nke.addCause(e);
                SysLogger.log2(3, this, "Failed to initialise cache in module [%1] :%2", this.mURI.toString(), e.getMessage());
                exception.addCause(nke);
            }
        }
        List transmutorClassNames = this.getReadable().getTexts("module/transreptors/transreptor", true);
        this.mTransreptors = new ArrayList(transmutorClassNames.size());
        Iterator i = transmutorClassNames.iterator();
        while (i.hasNext()) {
            String transmutorClassName = (String)i.next();
            try {
                Class transmutorClass = this.mClassLoader.loadClass(transmutorClassName);
                instance = (ITransrepresentor)transmutorClass.newInstance();
                instance.init(this, aContainer);
                this.mTransreptors.add(instance);
            }
            catch (Throwable e) {
                if (exception == null) {
                    exception = new NetKernelException("problems installing Transreptors");
                }
                e2 = new NetKernelException("problem installing Transreptor", null, transmutorClassName);
                e2.addCause(e);
                SysLogger.log3(3, this, "Failed to install transreptor [%1] in module [%2] : %3", transmutorClassName, this.mURI.toString(), e2.toString());
                exception.addCause(e2);
            }
        }
        transmutorClassNames = this.getReadable().getTexts("module/fragmentors/fragmentor", true);
        this.mFragmentors = new ArrayList(transmutorClassNames.size());
        i = transmutorClassNames.iterator();
        while (i.hasNext()) {
            String fragmentorClassName = (String)i.next();
            try {
                Class fragmentorClass = this.mClassLoader.loadClass(fragmentorClassName);
                instance = (IFragmentor)fragmentorClass.newInstance();
                instance.init(this, aContainer);
                this.mFragmentors.add(instance);
            }
            catch (Throwable e) {
                if (exception == null) {
                    exception = new NetKernelException("problems installing Fragmentors");
                }
                e2 = new NetKernelException("problem installing Fragmentor", null, fragmentorClassName);
                e2.addCause(e);
                SysLogger.log3(3, this, "Failed to install fragmentor [%1] in module [%2] : %3", fragmentorClassName, this.mURI.toString(), e2.toString());
                exception.addCause(e2);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public XMLReadable getReadable() {
        return this.mReadable;
    }

    private ModuleClassLoader createClassLoader(String aModuleURIString, ModuleManager aManager) throws MalformedURLException, IOException {
        ArrayList<String> jarURLs = new ArrayList<String>();
        jarURLs.add(aModuleURIString);
        if (aModuleURIString.startsWith("jar:")) {
            URL xarURL = new URL(aModuleURIString);
            JarURLConnection juc = (JarURLConnection)xarURL.openConnection();
            JarFile jf = juc.getJarFile();
            Matcher m = Pattern.compile("lib/.*\\.jar").matcher("");
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                m.reset(entry.getName());
                if (!m.matches()) continue;
                URL nestedJar = aManager.expandNestedJar(jf, entry, this.mURI, this.mVersion);
                jarURLs.add("jar:" + nestedJar.toString() + "!/");
            }
        } else {
            File libDir = new File(URI.create(aModuleURIString));
            if ((libDir = new File(libDir, "lib")).exists()) {
                FileFilter ff = new FileFilter(){

                    public boolean accept(File aFile) {
                        return aFile.getName().endsWith(".jar");
                    }
                };
                File[] filenames = libDir.listFiles(ff);
                for (int i = 0; i < filenames.length; ++i) {
                    jarURLs.add("jar:" + filenames[i].toURI().toString() + "!/");
                }
            }
        }
        ModuleClassLoader mcl = new ModuleClassLoader(this.getClass().getClassLoader(), jarURLs, this);
        return mcl;
    }

    public URIMapping getExportedURIMatches() {
        if (this.mExportedURIMatches == null) {
            List exportedURIs = this.getReadable().getTexts("module/export/uri/match", true);
            this.mExportedURIMatches = new URIMapping(exportedURIs, this);
        }
        return this.mExportedURIMatches;
    }

    public List getExportedClassMatches() {
        if (this.mExportedClasses == null) {
            this.mExportedClasses = this.getReadable().getTexts("module/export/class/match", true);
        }
        return this.mExportedClasses;
    }

    public PairList getResourceExpiries() {
        return this.mResourceExpirys;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public URIdentifier getURI() {
        return this.mURI;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return this.mURI.toString();
    }

    public URIdentifier rewrite(URIdentifier aURI) {
        return this.mRewriter.map(aURI);
    }

    public ITransrepresentor getTransrepresentorFor(IURRepresentation aFrom, Class aTo, List aLookedAtModules) {
        ITransrepresentor result;
        block3: {
            result = null;
            if (aLookedAtModules.contains(this)) break block3;
            aLookedAtModules.add(this);
            Iterator i = this.mTransreptors.iterator();
            while (i.hasNext()) {
                ITransrepresentor transmutor = (ITransrepresentor)i.next();
                if (!transmutor.supports(aFrom, aTo)) continue;
                result = transmutor;
                break;
            }
            if (result == null) {
                ModuleDefinition md;
                i = this.mImportedModules.iterator();
                while (i.hasNext() && (result = (md = (ModuleDefinition)i.next()).getTransrepresentorFor(aFrom, aTo, aLookedAtModules)) == null) {
                }
            }
        }
        return result;
    }

    public IFragmentor getFragmentorFor(URRequest aRequest, List aLookedAtModules) {
        IFragmentor result;
        block3: {
            result = null;
            if (aLookedAtModules.contains(this)) break block3;
            aLookedAtModules.add(this);
            Iterator i = this.mFragmentors.iterator();
            while (i.hasNext()) {
                IFragmentor fragmentor = (IFragmentor)i.next();
                if (!fragmentor.matches(aRequest)) continue;
                result = fragmentor;
                break;
            }
            if (result == null) {
                ModuleDefinition md;
                i = this.mImportedModules.iterator();
                while (i.hasNext() && (result = (md = (ModuleDefinition)i.next()).getFragmentorFor(aRequest, aLookedAtModules)) == null) {
                }
            }
        }
        return result;
    }

    public void write(Writer aWriter) throws IOException {
        aWriter.write("<module>");
        aWriter.write("<identity>");
        this.write(aWriter, "uri", "module/identity/uri");
        this.writeStringElement(aWriter, "version", this.getVersion().toString(3));
        aWriter.write("</identity>");
        aWriter.write("<info>");
        this.write(aWriter, "name", "module/info/name");
        this.write(aWriter, "description", "module/info/description");
        this.writeStringElement(aWriter, "source", this.mURIString);
        this.writeStringElement(aWriter, "scratch", this.getScratchDirURI());
        this.writeStringElement(aWriter, "editable", Boolean.toString(this.mEditable));
        this.writeStringElement(aWriter, "timestamp", Long.toString(this.mTimestamp));
        aWriter.write("</info>");
        aWriter.write("<publisher>");
        this.write(aWriter, "name", "module/publisher/name");
        this.write(aWriter, "uri", "module/publisher/uri");
        aWriter.write("</publisher>");
        aWriter.write("<licence>");
        this.write(aWriter, "name", "module/licence/name");
        this.write(aWriter, "uri", "module/licence/uri");
        aWriter.write("</licence>");
        aWriter.write("<dependencies>");
        List mappings = this.getReadable().getNodes("module/mapping/*");
        Iterator i = mappings.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (!n.getNodeName().equals(ELEMENT_IMPORT)) continue;
            XMLReadable imp = new XMLReadable(n);
            aWriter.write("<module>");
            String uri = imp.getText("uri").trim();
            this.writeStringElement(aWriter, "uri", uri);
            String error = imp.getText(ELEMENT_VALIDATION_ERROR);
            if (error.length() > 0) {
                this.write(aWriter, ELEMENT_VALIDATION_ERROR, imp, ELEMENT_VALIDATION_ERROR);
            } else {
                Object found = null;
                Iterator j = this.mImportedModules.iterator();
                while (j.hasNext()) {
                    ModuleDefinition md = (ModuleDefinition)j.next();
                    if (!md.getURI().toString().equals(uri)) continue;
                    this.writeStringElement(aWriter, "version", md.getVersion().toString(3));
                    break;
                }
            }
            aWriter.write("</module>");
        }
        aWriter.write("</dependencies>");
        aWriter.write("<raw>");
        XMLUtils.getInstance().toXML(aWriter, this.mDoc, false, true, "UTF-8", 4);
        aWriter.write("</raw>");
        aWriter.write("</module>");
    }

    private void write(Writer aWriter, String aName, String aXPath) throws IOException {
        this.write(aWriter, aName, this.mReadable, aXPath);
    }

    private void write(Writer aWriter, String aName, XMLReadable aReadable, String aXPath) throws IOException {
        String result = aReadable.getText(aXPath).trim();
        this.writeStringElement(aWriter, aName, result);
    }

    private void writeStringElement(Writer aWriter, String aName, String aValue) throws IOException {
        aWriter.write(60);
        aWriter.write(aName);
        aWriter.write(62);
        aWriter.write(XMLUtils.escape(aValue));
        aWriter.write("</");
        aWriter.write(aName);
        aWriter.write(62);
    }

    public boolean equals(Object aOther) {
        boolean result = false;
        if (aOther instanceof ModuleDefinition) {
            ModuleDefinition other = (ModuleDefinition)aOther;
            result = other.getURI().equals(this.getURI()) && other.getVersion().equals(this.getVersion());
        }
        return result;
    }
}

