/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module;

import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.util.DynamicURLClassLoader;
import com.ten60.netkernel.util.PairList;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleClassLoader
extends DynamicURLClassLoader {
    private PairList mImportMap;
    private ClassLoader mParent;
    private ModuleDefinition mModule;

    public ModuleClassLoader(ClassLoader aParent, List aURLs, ModuleDefinition aModule) {
        super(null, aURLs);
        this.mParent = aParent;
        this.mModule = aModule;
    }

    public ClassLoader getKernelClassLoader() {
        return this.mParent;
    }

    public ModuleDefinition getModule() {
        return this.mModule;
    }

    public void reset() {
        this.mImportMap = new PairList(10);
    }

    public void cleanup() {
        super.cleanup();
        this.mImportMap = null;
        this.mParent = null;
        this.mModule = null;
    }

    public void addImportedModule(ModuleDefinition aModule) {
        List matches = aModule.getExportedClassMatches();
        Iterator i = matches.iterator();
        while (i.hasNext()) {
            String match = (String)i.next();
            Matcher m = Pattern.compile(match).matcher("");
            this.mImportMap.put(m, aModule);
        }
    }

    public Class loadClass(String aName) throws ClassNotFoundException {
        Class<?> result;
        if (aName.startsWith("java.")) {
            result = this.findSystemClass(aName);
        } else {
            result = this.innerLocalLoadClass(aName);
            if (result == null) {
                result = this.loadImportedClass(aName);
            }
            if (result == null && this.mParent != null) {
                result = this.mParent.loadClass(aName);
            }
            if (result == null) {
                throw new ClassNotFoundException(aName);
            }
        }
        return result;
    }

    public Class loadClassAvoidingParent(String aName) throws ClassNotFoundException {
        Class result = null;
        if (aName.startsWith("java.")) {
            result = this.findSystemClass(aName);
        }
        if (result == null) {
            result = this.innerLocalLoadClass(aName);
        }
        if (result == null) {
            result = this.loadImportedClass(aName);
        }
        if (result == null) {
            throw new ClassNotFoundException(aName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadImportedClass(String aName) {
        Class<?> result = null;
        for (int i = 0; i < this.mImportMap.size(); ++i) {
            ModuleDefinition md;
            ClassLoader cl;
            boolean matches;
            Matcher m;
            Matcher matcher = m = (Matcher)this.mImportMap.getValue1(i);
            synchronized (matcher) {
                m.reset(aName);
                matches = m.matches();
            }
            if (!matches || (cl = (md = (ModuleDefinition)this.mImportMap.getValue2(i)).getClassLoader()) == null) continue;
            try {
                result = cl.loadClass(aName);
                break;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String aName) {
        URL result = super.getResource(aName);
        if (result == null) {
            String nameMatch = aName.replace('/', '.');
            for (int i = 0; i < this.mImportMap.size(); ++i) {
                ModuleDefinition md;
                ClassLoader cl;
                boolean matches;
                Matcher m;
                Matcher matcher = m = (Matcher)this.mImportMap.getValue1(i);
                synchronized (matcher) {
                    m.reset(nameMatch);
                    matches = m.matches();
                }
                if (matches && (result = (cl = (md = (ModuleDefinition)this.mImportMap.getValue2(i)).getClassLoader()).getResource(aName)) != null) break;
            }
        }
        if (result == null) {
            result = this.mParent.getResource(aName);
        }
        return result;
    }
}

