/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module;

import com.ten60.netkernel.module.MappedRequest;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urrequest.IRequestorContext;
import com.ten60.netkernel.urrequest.URRequest;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MappingCache {
    private Map mModules;
    private int mSize;
    private int mCullSize;
    static /* synthetic */ Class class$com$ten60$netkernel$urii$IURAccessor;

    public MappingCache(int aSize) {
        this.mSize = aSize;
        this.mCullSize = aSize / 8;
        this.mModules = new LinkedHashMap(aSize * 3 / 2, 0.9f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedRequest get(URRequest aRequest) {
        MCValue value;
        MappedRequest result = null;
        MCKey key = new MCKey(aRequest);
        Map map = this.mModules;
        synchronized (map) {
            value = (MCValue)this.mModules.get(key);
        }
        if (value != null) {
            result = value.getRequest(aRequest);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URRequest aRequest, MappedRequest aMapped) {
        MCValue value = new MCValue(aMapped);
        MCKey key = new MCKey(aRequest);
        Map map = this.mModules;
        synchronized (map) {
            if (this.mModules.size() > this.mSize) {
                Iterator entries = this.mModules.entrySet().iterator();
                for (int i = 0; i < this.mCullSize; ++i) {
                    entries.next();
                    entries.remove();
                }
            }
            this.mModules.remove(key);
            this.mModules.put(key, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MCValue {
        private IRequestorContext mModule;
        private URIdentifier mURA;
        private String mMappedString;
        private List mSuper;

        public MCValue(MappedRequest aRequest) {
            this.mModule = aRequest.getAccessorRequest().getContext();
            this.mURA = aRequest.getAccessorRequest().getURI();
            this.mMappedString = aRequest.getMappedRequest().getURI().toString();
            this.mSuper = aRequest.getMappedRequest().getSuperStack();
        }

        public MappedRequest getRequest(URRequest aOriginal) {
            URRequest ura = new URRequest(this.mURA, aOriginal.getRequestor(), aOriginal.getSession(), this.mModule, 1, aOriginal.getCWU(), aOriginal, class$com$ten60$netkernel$urii$IURAccessor == null ? (class$com$ten60$netkernel$urii$IURAccessor = MappingCache.class$("com.ten60.netkernel.urii.IURAccessor")) : class$com$ten60$netkernel$urii$IURAccessor);
            URRequest mapped = aOriginal.rewrite(new URIdentifier(this.mMappedString));
            mapped.setCurrentContext(this.mModule, this.mSuper);
            return new MappedRequest(ura, mapped);
        }
    }

    private static class MCKey {
        private IRequestorContext mModule;
        private String mRequestURIString;
        private List mSuperStack;

        public MCKey(URRequest aRequest) {
            this.mModule = aRequest.getContext();
            this.mRequestURIString = aRequest.getURI().toString();
            int i = this.mRequestURIString.indexOf(35);
            if (i >= 0) {
                this.mRequestURIString = this.mRequestURIString.substring(0, i);
            }
            this.mSuperStack = aRequest.getSuperStack();
        }

        public boolean equals(Object aOther) {
            boolean result;
            MCKey other = (MCKey)aOther;
            boolean bl = result = this.mModule == other.mModule && this.mRequestURIString.equals(other.mRequestURIString);
            if (result) {
                result = ((Object)this.mSuperStack).equals(other.mSuperStack);
            }
            return result;
        }

        public int hashCode() {
            return this.mRequestURIString.hashCode();
        }
    }
}

