/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.container;

import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Config;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.XMLReadable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HouseKeeper
extends ComponentImpl
implements Runnable {
    public static final URIdentifier URI = new URIdentifier("netkernel:hk");
    private long mPeriod;
    private int mStatBufferSize;
    private int mStatFreqDivider;
    private DateFormat mDateFormat;
    private Thread mThread;
    private boolean mStop;
    private Container mContainer;
    private long mMax = Runtime.getRuntime().maxMemory() >> 10;
    private static final int STAT_COUNT = 4;
    private long[] mStats;
    private long mBaseLine;
    private long mRealBaseLine;
    private long mPeak;
    private long mRealPeak;
    private long mLast;
    private int mFreqDivider;
    private int mBufferIndex;

    public HouseKeeper() {
        super(URI);
        if (System.getProperties().getProperty("java.version").startsWith("1.4.1")) {
            SysLogger.log(2, this, "Possible available memory misreporting due to JDK Bug 4686462 running on JDK1.4.1");
            this.mMax -= 65536L;
        }
    }

    public void start(Container aContainer) throws NetKernelException {
        this.mContainer = aContainer;
        Config config = (Config)aContainer.getComponent(Config.URI);
        XMLReadable cr = config.getReadable();
        this.mPeriod = cr.getInt("system/houseKeepingPeriod", 500);
        this.mStatBufferSize = cr.getInt("system/statistics/historySize", 60);
        this.mStatFreqDivider = cr.getInt("system/statistics/frequencyDivisor", 10);
        this.mDateFormat = new SimpleDateFormat(cr.getText("system/statistics/timestampFormat").trim());
        this.mStats = new long[this.mStatBufferSize * 4];
        Runtime r = Runtime.getRuntime();
        this.mLast = this.mBaseLine = r.totalMemory() - r.freeMemory();
        this.mPeak = this.mBaseLine;
        this.mThread = new Thread((Runnable)this, "HouseKeeper");
        this.mThread.start();
    }

    public void stop() {
        this.mStop = true;
        this.mThread.interrupt();
        try {
            this.mThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.mStop) {
            try {
                Thread.sleep(this.mPeriod);
                this.mContainer.doPeriodicHouseKeeping();
            }
            catch (Exception exception) {}
        }
    }

    public void doPeriodicHouseKeeping() {
        Runtime r = Runtime.getRuntime();
        long used = r.totalMemory() - r.freeMemory();
        if (used < this.mLast) {
            this.mRealBaseLine = used;
            this.mRealPeak = this.mLast;
            if (used < this.mBaseLine) {
                this.mBaseLine = used / 4L + this.mBaseLine * 3L / 4L;
            }
            if (this.mLast > this.mPeak) {
                this.mPeak = this.mLast / 4L + this.mPeak * 3L / 4L;
            }
        } else {
            this.mBaseLine = this.mBaseLine * 31L / 32L + this.mRealBaseLine / 32L;
            this.mPeak = this.mPeak * 31L / 32L + this.mRealPeak / 32L;
        }
        this.mLast = used;
        this.mFreqDivider = (this.mFreqDivider + 1) % this.mStatFreqDivider;
        if (this.mFreqDivider == 0) {
            this.mBufferIndex = (this.mBufferIndex + 4) % (this.mStatBufferSize * 4);
            this.mStats[this.mBufferIndex + 0] = System.currentTimeMillis();
            this.mStats[this.mBufferIndex + 1] = this.mBaseLine;
            this.mStats[this.mBufferIndex + 2] = this.mPeak;
            this.mStats[this.mBufferIndex + 3] = r.totalMemory();
        }
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream);
        osw.write("<memory>");
        HouseKeeper.write(osw, "max", Long.toString(this.mMax));
        int index = this.mBufferIndex;
        for (int i = 0; i < this.mStatBufferSize; ++i) {
            if ((index += 4) >= this.mStatBufferSize * 4) {
                index = 0;
            }
            osw.write("<stat>");
            HouseKeeper.write(osw, "baseline", Long.toString(this.mStats[index + 1] >> 10));
            HouseKeeper.write(osw, "peak", Long.toString(this.mStats[index + 2] >> 10));
            HouseKeeper.write(osw, "alloc", Long.toString(this.mStats[index + 3] >> 10));
            long time = this.mStats[index + 0];
            if (time == 0L) {
                HouseKeeper.write(osw, "time", "-");
            } else {
                HouseKeeper.write(osw, "time", this.mDateFormat.format(new Date(time)));
            }
            osw.write("</stat>");
        }
        osw.write("</memory>");
        osw.flush();
    }

    private static void write(OutputStreamWriter osw, String aName, String aValue) throws IOException {
        osw.write(60);
        osw.write(aName);
        osw.write(62);
        osw.write(aValue);
        osw.write("</");
        osw.write(aName);
        osw.write(62);
    }

    public final long getBaselineMemory() {
        return this.mBaseLine;
    }

    public final long getMaxMemory() {
        return this.mMax << 10;
    }

    public final long getPeakMemory() {
        return this.mPeak;
    }
}

