/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.container;

import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Config;
import com.ten60.netkernel.container.IComponent;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.transport.ITransport;
import com.ten60.netkernel.transport.TransportInitiatedSession;
import com.ten60.netkernel.transport.TransportManager;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urrequest.IRequestorContext;
import com.ten60.netkernel.urrequest.IRequestorSession;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.NetKernelURLConnection;
import com.ten60.netkernel.util.PairList;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.Utils;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.FileHandler;

public final class Container
extends ComponentImpl {
    public static final URIdentifier URI = new URIdentifier("netkernel:container");
    public static final String DEFAULT_CONFIG = "system.xml";
    public static final String VERSION = "2.6.2";
    public static final String NETKERNEL_URN = "urn:com:ten60:netkernel";
    private String mBasePath;
    private String mConfig;
    private String mScratchPath;
    private String mBasePathURI;
    private String mScratchPathURI;
    private boolean mIsStarted;
    private Scheduler mScheduler;
    private ModuleDefinition mExternalRequestContext;
    private Class[] mBootList = new Class[]{class$com$ten60$netkernel$container$Config == null ? (class$com$ten60$netkernel$container$Config = Container.class$("com.ten60.netkernel.container.Config")) : class$com$ten60$netkernel$container$Config, class$com$ten60$netkernel$cache$Cache == null ? (class$com$ten60$netkernel$cache$Cache = Container.class$("com.ten60.netkernel.cache.Cache")) : class$com$ten60$netkernel$cache$Cache, class$com$ten60$netkernel$module$ModuleManager == null ? (class$com$ten60$netkernel$module$ModuleManager = Container.class$("com.ten60.netkernel.module.ModuleManager")) : class$com$ten60$netkernel$module$ModuleManager, class$com$ten60$netkernel$scheduler$Scheduler == null ? (class$com$ten60$netkernel$scheduler$Scheduler = Container.class$("com.ten60.netkernel.scheduler.Scheduler")) : class$com$ten60$netkernel$scheduler$Scheduler, class$com$ten60$netkernel$transport$TransportManager == null ? (class$com$ten60$netkernel$transport$TransportManager = Container.class$("com.ten60.netkernel.transport.TransportManager")) : class$com$ten60$netkernel$transport$TransportManager, class$com$ten60$netkernel$container$HouseKeeper == null ? (class$com$ten60$netkernel$container$HouseKeeper = Container.class$("com.ten60.netkernel.container.HouseKeeper")) : class$com$ten60$netkernel$container$HouseKeeper};
    private final Map mComponentInstances = new LinkedHashMap();
    private ITransport mInternalTransport;
    private HashMap mStaticMap = new HashMap();
    private boolean mIsRestart;
    private long mStartTime;
    private Thread mShutdownThread;
    static /* synthetic */ Class class$com$ten60$netkernel$container$Config;
    static /* synthetic */ Class class$com$ten60$netkernel$cache$Cache;
    static /* synthetic */ Class class$com$ten60$netkernel$module$ModuleManager;
    static /* synthetic */ Class class$com$ten60$netkernel$scheduler$Scheduler;
    static /* synthetic */ Class class$com$ten60$netkernel$transport$TransportManager;
    static /* synthetic */ Class class$com$ten60$netkernel$container$HouseKeeper;
    static /* synthetic */ Class class$com$ten60$netkernel$urii$IURAspect;

    public static void main(String[] args) {
        if (args.length > 2) {
            System.err.println("usage: Container [<basepath> [<config>] ]");
            System.exit(0);
        }
        String basepath = args.length > 0 ? args[0] : null;
        String config = args.length > 1 ? args[1] : null;
        try {
            Container c;
            boolean shouldRestart;
            do {
                c = new Container(basepath, config);
                c.start();
            } while (shouldRestart = c.isRestart().booleanValue());
        }
        catch (NetKernelException e) {
            System.out.println(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Container() {
        this(null, null);
    }

    public Container(String aBasePath, String aConfig) {
        super(new URIdentifier("netkernel:container"));
        if (aBasePath != null) {
            this.setBasePath(aBasePath);
        }
        this.mConfig = aConfig != null ? Utils.fixSlash(aConfig) : DEFAULT_CONFIG;
    }

    private void setBasePath(String aBasePath) {
        this.mBasePath = Utils.fixSlash(aBasePath);
        if (!this.mBasePath.endsWith("/")) {
            this.mBasePath = this.mBasePath + "/";
        }
        this.mBasePathURI = File.separatorChar == '/' ? "file:" + this.mBasePath : "file:///" + this.mBasePath;
        this.mBasePathURI = this.mBasePathURI.replaceAll(" ", "%20");
    }

    public Boolean isRestart() {
        return this.mIsRestart;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    public void start(Container aContainer) throws NetKernelException {
        this.bootNotice();
        this.mComponentInstances.clear();
        this.startComponent(class$com$ten60$netkernel$container$Config == null ? (class$com$ten60$netkernel$container$Config = Container.class$("com.ten60.netkernel.container.Config")) : class$com$ten60$netkernel$container$Config);
        this.ensureScratchFound();
        this.configLoggers();
        SysLogger.log(6, this, "Starting container...");
        this.startComponents(false);
        this.mIsStarted = true;
        SysLogger.log(6, this, "Container started sucessfully");
        Runnable shutdownHook = new Runnable(){

            public void run() {
                try {
                    Container.this.innerStop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.mShutdownThread = new Thread(shutdownHook);
        Runtime.getRuntime().addShutdownHook(this.mShutdownThread);
        this.runInitProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws NetKernelException {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.start(this);
        Container container = this;
        synchronized (container) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    private void runInitProcess() {
        Config c = (Config)this.getComponent(Config.URI);
        URIdentifier moduleURI = new URIdentifier(c.getReadable().getText("/system/initModule").trim());
        URIdentifier requestURI = new URIdentifier(c.getReadable().getText("/system/initURI").trim());
        if (moduleURI.toString().length() != 0 && requestURI.toString().length() != 0) {
            try {
                this.ensureExternalRequestContext();
                ModuleManager mm = (ModuleManager)this.getComponent(ModuleManager.URI);
                ModuleDefinition md = mm.getModule(moduleURI, null, null);
                final TransportManager tm = (TransportManager)this.getComponent(TransportManager.URI);
                final URRequest request = new URRequest(requestURI, null, this.createSession(), md, 1, null, null, class$com$ten60$netkernel$urii$IURAspect == null ? (class$com$ten60$netkernel$urii$IURAspect = Container.class$("com.ten60.netkernel.urii.IURAspect")) : class$com$ten60$netkernel$urii$IURAspect);
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                tm.innerHandleRequest(request, Container.this.mInternalTransport);
                            }
                            catch (Exception e) {
                                SysLogger.log(2, this, "Failed to launch init process");
                                e.printStackTrace();
                                Object var3_2 = null;
                                Runtime.getRuntime().gc();
                                SysLogger.log(6, this, "Accepting external requests...");
                                tm.acceptRequests();
                                Container.this.mStartTime = System.currentTimeMillis();
                                return;
                            }
                            Object var3_1 = null;
                            Runtime.getRuntime().gc();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            Runtime.getRuntime().gc();
                            SysLogger.log(6, this, "Accepting external requests...");
                            tm.acceptRequests();
                            Container.this.mStartTime = System.currentTimeMillis();
                            throw throwable;
                        }
                        SysLogger.log(6, this, "Accepting external requests...");
                        tm.acceptRequests();
                        Container.this.mStartTime = System.currentTimeMillis();
                    }
                };
                Thread t = new Thread(r);
                t.start();
            }
            catch (Exception e) {
                SysLogger.log(2, this, "Failed to launch init process");
            }
        } else {
            TransportManager tm = (TransportManager)this.getComponent(TransportManager.URI);
            SysLogger.log(6, this, "Accepting external requests...");
            tm.acceptRequests();
        }
    }

    private void startComponents(boolean aHot) throws NetKernelException {
        NetKernelException result = null;
        for (int i = 0; i < this.mBootList.length; ++i) {
            Class componentClass = this.mBootList[i];
            try {
                if (!aHot || componentClass != (class$com$ten60$netkernel$transport$TransportManager == null ? Container.class$("com.ten60.netkernel.transport.TransportManager") : class$com$ten60$netkernel$transport$TransportManager)) {
                    this.startComponent(componentClass);
                    continue;
                }
                IComponent component = (IComponent)this.mComponentInstances.get(TransportManager.URI);
                component.start(this);
                continue;
            }
            catch (NetKernelException e) {
                if (result == null) {
                    result = new NetKernelException("Failed to start container", "Some components did not start correctly", null);
                }
                result.addCause(e);
            }
        }
        this.mScheduler = (Scheduler)this.getComponent(Scheduler.URI);
        this.mExternalRequestContext = null;
        if (result != null) {
            SysLogger.log(6, this, result.toString());
            throw result;
        }
    }

    private void configLoggers() throws NetKernelException {
        Config config = (Config)this.getComponent(Config.URI);
        XMLReadable c = config.getReadable();
        SysLogger.config(c);
        try {
            FileHandler fileHandler = new FileHandler(this.getBasePath().replaceAll("%20", " ") + "log/netkernel%g.log", 131072, 2, false);
            SysLogger.addPermanentHandler(fileHandler);
        }
        catch (IOException e) {
            NetKernelException nke = new NetKernelException("Failed initialise log file");
            nke.addCause(e);
            throw nke;
        }
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    private void startComponent(Class aComponentClass) throws NetKernelException {
        try {
            SysLogger.log1(6, this, "Starting %1", aComponentClass.getName());
            IComponent result = (IComponent)aComponentClass.newInstance();
            this.mComponentInstances.put(result.getURI(), result);
            result.start(this);
        }
        catch (Exception e) {
            NetKernelException e2 = new NetKernelException("Failed to start component", null, aComponentClass.getName());
            e2.addCause(e);
            throw e2;
        }
    }

    public void stop() throws NetKernelException {
        this.innerStop();
        if (this.mShutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.mShutdownThread);
            this.mShutdownThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerStop() throws NetKernelException {
        SysLogger.log(6, this, "Stopping container");
        TransportManager tm = (TransportManager)this.getComponent(TransportManager.URI);
        if (tm != null) {
            SysLogger.log(6, this, "Rejecting new requests");
            tm.rejectRequests();
        }
        if (this.mScheduler != null) {
            this.mScheduler.getDebugger().releaseAll();
            SysLogger.log(6, this, "Waiting for existing requests to complete...");
            tm.join();
        }
        this.stopComponents(false);
        SysLogger.log(6, this, "Container stopped sucessfully");
        this.mIsStarted = false;
        this.mIsRestart = false;
        Container container = this;
        synchronized (container) {
            this.notify();
        }
    }

    private void stopComponents(boolean aHot) throws NetKernelException {
        NetKernelException result = null;
        ArrayList l = new ArrayList(this.mComponentInstances.values());
        Collections.reverse(l);
        Iterator i = l.iterator();
        while (i.hasNext()) {
            IComponent component = (IComponent)i.next();
            if (aHot && component instanceof TransportManager) continue;
            i.remove();
            try {
                SysLogger.log1(6, this, "Stopping [%1]", component.getClass().getName());
                component.stop();
            }
            catch (Exception e) {
                if (result == null) {
                    result = new NetKernelException("Exceptions thrown stopping container", "Some components didnt stop correctly", null);
                }
                result.addCause(e);
            }
        }
        if (result != null) {
            SysLogger.log(6, this, result.toString());
            throw result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(boolean aHot) {
        TransportManager tm = (TransportManager)this.getComponent(TransportManager.URI);
        if (aHot) {
            SysLogger.log(6, this, "Hot Restart initiated, holding new requests...");
            tm.holdRequests();
        } else {
            SysLogger.log(6, this, "Cold Restart initiated, rejecting new requests...");
            tm.rejectRequests();
        }
        SysLogger.log(6, this, "Waiting for existing requests to complete...");
        this.mScheduler.getDebugger().releaseAll();
        tm.join();
        SysLogger.log(6, this, "Stopping Kernel");
        boolean problems = false;
        try {
            this.stopComponents(aHot);
        }
        catch (NetKernelException e) {
            problems = true;
        }
        this.mStaticMap.clear();
        if (!aHot) {
            ModuleManager.resetModuleFactory();
            XMLUtils.destroyInstances();
            this.mIsRestart = true;
            if (this.mShutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.mShutdownThread);
                this.mShutdownThread = null;
            }
            Container e = this;
            synchronized (e) {
                this.notify();
            }
        }
        SysLogger.resetStats();
        SysLogger.log(6, this, "Starting Kernel");
        try {
            this.startComponents(aHot);
        }
        catch (NetKernelException e) {
            problems = true;
        }
        if (problems) {
            SysLogger.log(6, this, "Restart Completed but problems were encountered");
        } else {
            SysLogger.log(6, this, "Restart Completed sucessfully");
        }
        this.runInitProcess();
    }

    public IComponent getComponent(URIdentifier aURI) {
        IComponent result = aURI.equals(URI) ? this : (IComponent)this.mComponentInstances.get(aURI);
        return result;
    }

    public String getBasePath() {
        return this.mBasePath;
    }

    public String getScratchPath() {
        return this.mScratchPath;
    }

    public String getConfigPath() {
        return this.mConfig;
    }

    public String getBasePathURI() {
        return this.mBasePathURI;
    }

    public String getScratchPathURI() {
        return this.mScratchPathURI;
    }

    private void ensureScratchFound() throws NetKernelException {
        Config c = (Config)this.getComponent(Config.URI);
        if (this.mBasePath == null) {
            String basepath = c.getReadable().getText("system/basePath").trim();
            if (basepath.length() == 0) {
                throw new NetKernelException("basepath not specified on commandline or in system.xml");
            }
            this.setBasePath(basepath);
        }
        System.err.println("Basepath URI: " + this.mBasePathURI);
        if (this.mScratchPath == null) {
            File scratch = new File(this.mBasePath, c.getReadable().getText("system/scratchDir").trim());
            try {
                this.mScratchPath = scratch.getCanonicalPath();
                if (!this.mScratchPath.endsWith("/")) {
                    this.mScratchPath = this.mScratchPath + "/";
                }
                this.mScratchPath = Utils.fixSlash(this.mScratchPath);
                this.mScratchPathURI = scratch.toURI().toString().replaceAll(" ", "%20");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doPeriodicHouseKeeping() {
        Iterator i = this.mComponentInstances.values().iterator();
        while (i.hasNext()) {
            IComponent comp = (IComponent)i.next();
            comp.doPeriodicHouseKeeping();
        }
    }

    public IURRepresentation requestResource(URIdentifier aURI, Class aAspectClass, Map aArgs) throws NetKernelException {
        IRequestorSession session = this.createSession();
        this.ensureExternalRequestContext();
        URRequest request = new URRequest(aURI, null, session, this.mExternalRequestContext, 1, null, null, aAspectClass);
        if (aArgs != null) {
            Iterator i = aArgs.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                URIdentifier uri = new URIdentifier((String)entry.getKey());
                IURRepresentation representation = (IURRepresentation)entry.getValue();
                request.addArg(uri, representation);
            }
        }
        TransportManager tm = (TransportManager)this.getComponent(TransportManager.URI);
        return tm.handleRequest(request, this.mInternalTransport);
    }

    private IRequestorSession createSession() {
        return new TransportInitiatedSession();
    }

    public ClassLoader getExternalRequestClassLoader() throws NetKernelException {
        this.ensureExternalRequestContext();
        return this.mExternalRequestContext.getClassLoader();
    }

    private void ensureExternalRequestContext() throws NetKernelException {
        if (this.mExternalRequestContext == null) {
            ModuleManager mm = (ModuleManager)this.getComponent(ModuleManager.URI);
            PairList pl = mm.getTransports();
            for (int i = 0; i < pl.size(); ++i) {
                if (!pl.getValue1(i).equals("InternalTransport")) continue;
                this.mExternalRequestContext = (ModuleDefinition)pl.getValue2(i);
                break;
            }
            this.mInternalTransport = new ITransport(){

                public void start(Container aContainer, IRequestorContext aContext) {
                }

                public void stop() {
                }

                public void setContext(IRequestorContext aContext) {
                }

                public String getDescription() {
                    return "Internal Transport";
                }
            };
            if (this.mExternalRequestContext == null) {
                throw new NetKernelException("No Module defined as fulcrum for Internal Transport");
            }
        }
    }

    public URLConnection openConnection(URL u) throws IOException {
        return new NetKernelURLConnection(u, this);
    }

    public Object getStatic(Object aKey) {
        return this.mStaticMap.get(aKey);
    }

    public Object putStatic(Object aKey, Object aValue) {
        return this.mStaticMap.put(aKey, aValue);
    }

    private void bootNotice() {
        System.out.println("************************************************************");
        System.out.println("* 1060(R) NetKernel(TM) version 2.6.2");
        System.out.println("* Copyright (C) 2002-2005, 1060 Research Limited");
        System.out.println("* Licensed under the 1060 Public License v1.0");
        System.out.println("* To review this license or to obtain alternative licenses");
        System.out.println("* please visit www.1060research.com");
        System.out.println("************************************************************");
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream);
        osw.write("<container>");
        osw.write("<basepath>");
        URI u = java.net.URI.create(this.getBasePathURI());
        File f = new File(u);
        osw.write(XMLUtils.escape(f.getAbsolutePath() + File.separator));
        osw.write("</basepath>");
        osw.write("<basepathURI>");
        osw.write(this.getBasePathURI());
        osw.write("</basepathURI>");
        osw.write("</container>");
        osw.flush();
    }

    public URL getBootloaderConfigURL() {
        URL result = this.getClass().getClassLoader().getResource("bootloader.cfg");
        return result;
    }

    public URL getKernelSourceURL() throws IOException {
        URL result;
        URL bootloaderConfigURL = this.getBootloaderConfigURL();
        if (bootloaderConfigURL != null) {
            InputStream is = bootloaderConfigURL.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String path = br.readLine();
            path = File.separatorChar == '/' ? "file:" + path : "file:///" + path;
            path = path.replace('\\', '/');
            path = path.replaceAll(" ", "%20");
            result = new URL(path);
        } else {
            result = null;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

