/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.container;

import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Utils;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Document;

public class Config
extends ComponentImpl {
    public static final URIdentifier URI = new URIdentifier("netkernel:config");
    private Document mDocument;
    private XMLReadable mReadable;
    private URL mURL;

    public Config() {
        super(URI);
    }

    public void start(Container aContainer) throws NetKernelException {
        boolean proxyEnabled;
        this.mURL = this.getClass().getClassLoader().getResource(aContainer.getConfigPath());
        if (this.mURL == null) {
            throw new NetKernelException("configuration " + aContainer.getConfigPath() + " not found");
        }
        try {
            URLConnection con = this.mURL.openConnection();
            InputStream is = con.getInputStream();
            this.mDocument = XMLUtils.parse(is);
            this.mReadable = new XMLReadable(this.mDocument);
            is.close();
            NetKernelException.setTraceDepth(this.mReadable.getInt("system/exceptionStackDepth", 4));
        }
        catch (Exception e) {
            NetKernelException e2 = new NetKernelException("failed to read/parse configuration");
            e2.addCause(e);
            throw e2;
        }
        boolean bl = proxyEnabled = !this.mReadable.getText("/system/proxy/type").equals("none");
        if (proxyEnabled) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", this.mReadable.getText("/system/proxy/host"));
            System.getProperties().put("proxyPort", this.mReadable.getText("/system/proxy/port"));
        } else {
            System.getProperties().put("proxySet", "false");
        }
    }

    public XMLReadable getReadable() {
        return this.mReadable;
    }

    public void write(OutputStream aStream) throws IOException {
        URLConnection con = this.mURL.openConnection();
        InputStream is = con.getInputStream();
        Utils.pipe(is, aStream);
    }

    public void sink(IAspectBinaryStream aData) throws IOException, NetKernelException {
        if (!this.mURL.getProtocol().equals("file")) {
            throw new NetKernelException("Config not read from file", "It cannot be updated", this.mURL.toString());
        }
        URI uri = java.net.URI.create(this.mURL.toString());
        File f = new File(uri);
        FileOutputStream os = new FileOutputStream(f);
        aData.write(os);
        os.close();
    }
}

