/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: OrchextraAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2006/01/13 15:59:42 $
 *****************************************************************************/
package org.ten60.orchextra;

import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.aspect.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.logging.*;
import org.w3c.dom.*;

/**
 *
 * @author  pjr
 */
public class OrchextraAccessor extends NKFAccessorImpl{
	
	private static final String COMMAND_START="start";
	private static final String COMMAND_STOP="stop";
	private static final String COMMAND_STATUS="status";
	private static final String COMMAND_HISTORY="history";
	private static final String COMMAND_PLAYING="playing";
	private static final String COMMAND_QUEUE="queue";
	private static final String COMMAND_SKIP="skip";
	private static final String COMMAND_GETLIST="getlist";
	private static final String COMMAND_ADDSONG="addsong";
	private static final String COMMAND_REMOVE="remove";
	private static final String COMMAND_JUMP="jump";
	private static final String COMMAND_JUMPALL="jumpall";
	private static final String COMMAND_SEARCH="search";
	private static final String COMMAND_RELOAD="reload";
	private static final String COMMAND_RECONFIGURE="reconfigure";
	
	private static final int START=1;
	private static final int STOP=2;
	private static final int STATUS=3;
	private static final int HISTORY=4;
	private static final int PLAYING=5;
	private static final int QUEUE=6;
	private static final int SKIP=7;
	private static final int GETLIST=8;
	private static final int ADDSONG=9;
	private static final int REMOVE=10;
	private static final int JUMP=11;
	private static final int JUMPALL=12;
	private static final int SEARCH=13;
	private static final int RELOAD=14;
	private static final int RECONFIGURE=15;
	
	private static final HashMap map=new HashMap();
	
	{
		map.put(COMMAND_START, new Integer(START));
		map.put(COMMAND_STOP, new Integer(STOP));
		map.put(COMMAND_STATUS, new Integer(STATUS));
		map.put(COMMAND_HISTORY, new Integer(HISTORY));
		map.put(COMMAND_PLAYING, new Integer(PLAYING));
		map.put(COMMAND_QUEUE, new Integer(QUEUE));
		map.put(COMMAND_SKIP, new Integer(SKIP));
		map.put(COMMAND_GETLIST, new Integer(GETLIST));
		map.put(COMMAND_ADDSONG, new Integer(ADDSONG));
		map.put(COMMAND_REMOVE, new Integer(REMOVE));
		map.put(COMMAND_JUMP, new Integer(JUMP));
		map.put(COMMAND_JUMPALL, new Integer(JUMPALL));
		map.put(COMMAND_SEARCH, new Integer(SEARCH));
		map.put(COMMAND_RELOAD, new Integer(RELOAD));
		map.put(COMMAND_RECONFIGURE, new Integer(RECONFIGURE));
	}
	
	private XMLStreamsicle xs=null;
	
	/** Creates a new instance of OrchextraAccessor */
	public OrchextraAccessor()
	{	super(100,true,INKFRequestReadOnly.RQT_SOURCE);
		System.err.println("***********Created ORCHEXTRA***********");
		
		if(xs==null)
		{	XMLStreamsicle.initialise();
			xs=XMLStreamsicle.getInstance();			
		}
	}
	
	public final static int DEBUG=0;
	public final static int FINE=1;
	public final static int INFO=2;
	public final static int WARNING=3;
	public final static int SEVERE=4;
	private static final String ORCHEXTRA_LOGGER="OrchextraLogger";
	private static final Handler mLogHandler=new ConsoleHandler();
	
	public static void log(int level, Object aObject, String aMessage)
	{	Logger aLogger=Logger.getLogger(ORCHEXTRA_LOGGER);
		if(aLogger.getHandlers().length==0)
		{	aLogger.setUseParentHandlers(false);
			aLogger.addHandler(mLogHandler);
			aLogger.setLevel(Level.ALL);
		}
		switch(level)
		{	case DEBUG:
				aLogger.log(Level.FINER, aMessage, aObject);
			break;	
			case FINE:
				aLogger.log(Level.FINE, aMessage, aObject);
			break;
			case INFO:
				aLogger.log(Level.INFO, aMessage, aObject);
			break;
			case WARNING:
				aLogger.log(Level.WARNING, aMessage, aObject);
			break;
			case SEVERE:
				aLogger.log(Level.SEVERE, aMessage, aObject);
			break;
		}
		
	}
	
	private URI getScratchDir(INKFConvenienceHelper context)
	{	String scratch= context.getKernelHelper().getOwningModule().getScratchDirURI();
		log(INFO, this, "ScratchPath="+scratch);
		return URI.create(scratch);
		
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	synchronized(xs)
		{	if(!xs.isStarted())
			{
				IXDAReadOnly properties=((IXAspect)context.sourceAspect("ffcpl:/org/ten60/orchextra/fluid.config.xml", IXAspect.class)).getXDA();
				//Unpack hosts.rules if it's still jarred
				String fileprefix;
				if(File.separatorChar=='/')
				{	fileprefix="file:";
				}
				else	fileprefix="file:/";	
				URI path=getScratchDir(context);
				System.err.println("Scratch Path = "+path.toString());
				try
				{	String hosts="ffcpl:/org/ten60/orchextra/hosts.rules";
					IAspectString sa=(IAspectString)context.sourceAspect(hosts, IAspectString.class);
					context.sinkAspect(hosts, sa);
				}
				catch(Exception e)
				{	NetKernelException nke=new NetKernelException("Error sinking hosts.rules");
					nke.addCause(e);
					throw nke;
				}

				XMLToProperties xtop=new XMLToProperties(properties);
				xs.config(xtop.parse(), getScratchDir(context));
				log(INFO, this, "XMLStreamsicle Server Initialised");
			}	
			
			IXDAReadOnly opt=((IXAspect)context.sourceAspect("this:param:operator",IXAspect.class)).getXDA();
			String command=opt.getText("/command/@type",true);
			String result=null;
			DOMXDA resultd=null;
			Integer action=(Integer)map.get(command);
			switch(action.intValue())
			{
				case START:
					if (!xs.isStarted())
					{	xs.start();
						if(xs.isStarted())
						{	log(INFO, this, "Orchextra Server Started");
							result="<xs>started</xs>";
						}
						else
						{	log(WARNING, this, "Orchextra Server Failed to Start");
						}
					}
					
				break;
				case STOP:
					if (xs.isStarted())
					{	xs.stop();
					}
					result="<xs>stopped</xs>";
				break;
				case STATUS:
					result=xs.getStatus();
				break;
				case HISTORY:
					resultd=xs.getHistory();
				break;
				case PLAYING:
					resultd=xs.getPlaying();
				break;
				case QUEUE:
					resultd=xs.getQueueList();
				break;
				case SKIP:
					xs.skip();
				break;
				case GETLIST:
					String value=opt.getText("/command",true);
					if (value.equals("")) value="0";
					resultd=xs.getList(Integer.parseInt(value));
				break;
				case ADDSONG:
					String owner=((IXAspect)context.sourceAspect("this:param:param",IXAspect.class)).getXDA().getText("/owner", true);
					IXDAReadOnlyIterator ri=opt.readOnlyIterator("/command/song");
					while(ri.hasNext())
					{	ri.next();
						xs.addSong(Integer.parseInt(ri.getText(".",true)), owner);
					}
				break;
				case REMOVE:
					xs.removeFromQueue(Integer.parseInt(opt.getText("/command",true)));
				break;
				case JUMP:
					xs.jumpOne(Integer.parseInt(opt.getText("/command",true)));
				break;
				case JUMPALL:
					xs.jumpQueue(Integer.parseInt(opt.getText("/command",true)));
				break;
				case SEARCH:
					resultd=xs.search(opt.getText("/command",true));
				break;
				case RELOAD:
					xs.reconfigure();
					log(INFO, this, "Orchextra Server Reloaded");
				break;
				case RECONFIGURE:
					IXDAReadOnly properties=((IXAspect)context.sourceAspect("ffcpl:/org/ten60/orchextra/fluid.config.xml",IXAspect.class)).getXDA();
					XMLToProperties xtop=new XMLToProperties(properties);
					xs.reconfigureProperties(xtop.parse());
					log(INFO, this, "Orchextra Server Reconfigured");
				break;
			}
			
			IURAspect aspect=null;
			if(resultd!=null)
			{	aspect=new DOMXDAAspect(resultd);
			}
			else
			{	if(result==null)
				{	aspect=new org.ten60.netkernel.layer1.representation.VoidAspect();
				}
				else
				{	aspect= new org.ten60.netkernel.layer1.representation.StringAspect(result);
				}
			}
			INKFResponse resp=context.createResponseFrom(aspect);
			resp.setMimeType("text/xml");
			context.setResponse(resp);
		}			
	}
	
	public void destroy()
	{	try
		{	if(xs.isStarted())
			{	xs.stop();
			}
			xs=null;
		}
		catch(Exception e){/* do nothing */}
	}
	
}
