package com.streamsicle.songinfo;

// Import log4j classes.
import org.ten60.orchextra.*;

/**
 *  <P>
 *
 *  SongInfo that is read in from an ID3v1 tag. Some code from the original
 *  com.streamsicle.fluid.ID3Tag was used. This class actually supports ID3v1
 *  and ID3v1.1.</P> <P>
 *
 *  More info can be found at <A href="http://pasp.de/mp3/ID3-Tag.html">
 *  http://pasp.de/mp3/ID3-Tag.html</A> and <A
 *  href="http://www.id3.org/id3v1.html">http://www.id3.org/id3v1.html</A> .
 *  </P>
 *
 *@author     mhall
 *@created    September 17, 2002
 */
public class SongInfoID3v1 extends SongInfo {
    /**
     *  The size of an ID3v1 tag in bytes.
     */
    public final static int TAGSIZE = 128;

    /**
     *  The delimiter with which a valid tag starts.
     */
    public final static String DELIMITER = "TAG";

    /**
     *  Contains the genres as specified in the ID3 v1.0 specification.
     */
    public final static String[] GENRE_LIST = {
            "Blues",
            "Classic Rock",
            "Country",
            "Dance",
            "Disco",
            "Funk",
            "Grunge",
            "Hip-Hop",
            "Jazz",
            "Metal",
            "New Age",
            "Oldies",
            "Other",
            "Pop",
            "R&B",
            "Rap",
            "Reggae",
            "Rock",
            "Techno",
            "Industrial",
            "Alternative",
            "Ska",
            "Death Metal",
            "Pranks",
            "Soundtrack",
            "Euro-Techno",
            "Ambient",
            "Trip-Hop",
            "Vocal",
            "Jazz+Funk",
            "Fusion",
            "Trance",
            "Classical",
            "Instrumental",
            "Acid",
            "House",
            "Game",
            "Sound Clip",
            "Gospel",
            "Noise",
            "AlternRock",
            "Bass",
            "Soul",
            "Punk",
            "Space",
            "Meditative",
            "Instrumental Pop",
            "Instrumental Rock",
            "Ethnic",
            "Gothic",
            "Darkwave",
            "Techno-Industrial",
            "Electronic",
            "Pop-Folk",
            "Eurodance",
            "Dream",
            "Southern Rock",
            "Comedy",
            "Cult",
            "Gangsta",
            "Top 40",
            "Christian Rap",
            "Pop/Funk",
            "Jungle",
            "Native American",
            "Cabaret",
            "New Wave",
            "Psychadelic",
            "Rave",
            "Showtunes",
            "Trailer",
            "Lo-Fi",
            "Tribal",
            "Acid Punk",
            "Acid Jazz",
            "Polka",
            "Retro",
            "Musical",
            "Rock & Roll",
            "Hard Rock",
            "Folk",
            "Folk-Rock",
            "National Folk",
            "Swing",
            "Fast Fusion",
            "Bebob",
            "Latin",
            "Revival",
            "Celtic",
            "Bluegrass",
            "Avantgarde",
            "Gothic Rock",
            "Progressive Rock",
            "Psychedelic Rock",
            "Symphonic Rock",
            "Slow Rock",
            "Big Band",
            "Chorus",
            "Easy Listening",
            "Acoustic",
            "Humour",
            "Speech",
            "Chanson",
            "Opera",
            "Chamber Music",
            "Sonata",
            "Symphony",
            "Booty Bass",
            "Primus",
            "Porn Groove",
            "Satire",
            "Slow Jam",
            "Club",
            "Tango",
            "Samba",
            "Folklore",
            "Ballad",
            "Power Ballad",
            "Rhythmic Soul",
            "Freestyle",
            "Duet",
            "Punk Rock",
            "Drum Solo",
            "A capella",
            "Euro-House",
            "Dance Hall"
            };


    /**
     *  Description of the Method
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    private final static String clean(String str) {
        String tmp = str.trim();
        if (tmp.length() == 0) {
            return null;
        } else {
            return tmp;
        }
    }


    private String m_title, m_artist, m_album, m_year, m_comment, m_trackNumber, m_genre;


    /**
     *  Create a SongInfo object from an ID3v1 tag. tag is the 128 byte tag.
     *
     *@param  tag  Description of the Parameter
     */
    public SongInfoID3v1(byte[] tag) {
        m_title = clean(new String(tag, 3, 30));
        m_artist = clean(new String(tag, 33, 30));
        m_album = clean(new String(tag, 63, 30));
        m_year = clean(new String(tag, 93, 4));

        if (tag[TAGSIZE - 3] == 0 && tag[TAGSIZE - 2] != 0) {
            // tag is ID3v1.1
            m_comment = clean(new String(tag, 97, 28));
            m_trackNumber = String.valueOf(tag[TAGSIZE - 2]);
        } else {
            // tag is ID3v1
            m_comment = clean(new String(tag, 97, 30));
            m_trackNumber = null;
        }

        if (tag[TAGSIZE - 1] < 126 && tag[TAGSIZE - 1] >= 0) {
            m_genre = GENRE_LIST[tag[TAGSIZE - 1]];
        } else {
            m_genre = null;
        }
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasTitle() {
        return (m_title != null);
    }


    /**
     *  Gets the title attribute of the SongInfoID3v1 object
     *
     *@return    The title value
     */
    public String getTitle() {
        return m_title;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasArtist() {
        return (m_artist != null);
    }


    /**
     *  Gets the artist attribute of the SongInfoID3v1 object
     *
     *@return    The artist value
     */
    public String getArtist() {
        return m_artist;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasAlbum() {
        return (m_album != null);
    }


    /**
     *  Gets the album attribute of the SongInfoID3v1 object
     *
     *@return    The album value
     */
    public String getAlbum() {
        return m_album;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasTrackNumber() {
        return (m_trackNumber != null);
    }


    /**
     *  Gets the trackNumber attribute of the SongInfoID3v1 object
     *
     *@return    The trackNumber value
     */
    public String getTrackNumber() {
        return m_trackNumber;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasYear() {
        return (m_year != null);
    }


    /**
     *  Gets the year attribute of the SongInfoID3v1 object
     *
     *@return    The year value
     */
    public String getYear() {
        return m_year;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasGenre() {
        return (m_genre != null);
    }


    /**
     *  Gets the genre attribute of the SongInfoID3v1 object
     *
     *@return    The genre value
     */
    public String getGenre() {
        return m_genre;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasComment() {
        return (m_comment != null);
    }


    /**
     *  Gets the comment attribute of the SongInfoID3v1 object
     *
     *@return    The comment value
     */
    public String getComment() {
        return m_comment;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasComposer() {
        return false;
    }


    /**
     *  Gets the composer attribute of the SongInfoID3v1 object
     *
     *@return    The composer value
     */
    public String getComposer() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasOriginalArtist() {
        return false;
    }


    /**
     *  Gets the originalArtist attribute of the SongInfoID3v1 object
     *
     *@return    The originalArtist value
     */
    public String getOriginalArtist() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasURL() {
        return false;
    }


    /**
     *  Gets the uRL attribute of the SongInfoID3v1 object
     *
     *@return    The uRL value
     */
    public String getURL() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasTimeLength() {
        return true;
    }


    /**
     *  Gets the timeLength attribute of the SongInfoID3v1 object
     *
     *@return    The timeLength value
     */
    public String getTimeLength() {
        // in milliseconds
        long size = fileSize * 8L / (long) bitRate;
        return Long.toString(size);
    }
}
