package com.streamsicle.songinfo;

import java.io.*;

/**
 *  SongInfo that is read from the filename.
 *
 *@author     mhall
 *@created    September 17, 2002
 */
public class SongInfoFile extends SongInfo {
    private String m_title;


    /**
     *  Constructor for the SongInfoFile object
     *
     *@param  songFile  Description of the Parameter
     */
    public SongInfoFile(File songFile) {
        String filename = songFile.getName();
        int dot = filename.lastIndexOf(".");
        try {
            m_title = filename.substring(0, dot);
        } catch (java.lang.StringIndexOutOfBoundsException e) {
            // the file didn't have an extension
            m_title = "";
        }
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasTitle() {
        return true;
    }


    /**
     *  Gets the title attribute of the SongInfoFile object
     *
     *@return    The title value
     */
    public String getTitle() {
        return m_title;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasArtist() {
        return false;
    }


    /**
     *  Gets the artist attribute of the SongInfoFile object
     *
     *@return    The artist value
     */
    public String getArtist() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasAlbum() {
        return false;
    }


    /**
     *  Gets the album attribute of the SongInfoFile object
     *
     *@return    The album value
     */
    public String getAlbum() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasTrackNumber() {
        return false;
    }


    /**
     *  Gets the trackNumber attribute of the SongInfoFile object
     *
     *@return    The trackNumber value
     */
    public String getTrackNumber() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasYear() {
        return false;
    }


    /**
     *  Gets the year attribute of the SongInfoFile object
     *
     *@return    The year value
     */
    public String getYear() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasGenre() {
        return false;
    }


    /**
     *  Gets the genre attribute of the SongInfoFile object
     *
     *@return    The genre value
     */
    public String getGenre() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasComment() {
        return false;
    }


    /**
     *  Gets the comment attribute of the SongInfoFile object
     *
     *@return    The comment value
     */
    public String getComment() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasComposer() {
        return false;
    }


    /**
     *  Gets the composer attribute of the SongInfoFile object
     *
     *@return    The composer value
     */
    public String getComposer() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasOriginalArtist() {
        return false;
    }


    /**
     *  Gets the originalArtist attribute of the SongInfoFile object
     *
     *@return    The originalArtist value
     */
    public String getOriginalArtist() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasURL() {
        return false;
    }


    /**
     *  Gets the uRL attribute of the SongInfoFile object
     *
     *@return    The uRL value
     */
    public String getURL() {
        return null;
    }


    /**
     *  Description of the Method
     *
     *@return    Description of the Return Value
     */
    public boolean hasTimeLength() {
        return true;
    }


    /**
     *  Gets the timeLength attribute of the SongInfoFile object
     *
     *@return    The timeLength value
     */
    public String getTimeLength() {
        if (bitRate > 0) {
           long size = fileSize * 8L / (long) bitRate;
           // above formula is file_size * 8 bits/byte * 1Kb / 1024bits * 1sec/bitRateInKb
           return Long.toString(size);
        } else {
           return "1";
        }
    }
}
