/******************************************************************************
 * (c) Copyright 2002,2005, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: PresetTransreptor.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2006/02/20 16:56:59 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.transrepresentation;

import org.ten60.netkernel.pingpong.representation.IAspectConstants;
import org.ten60.netkernel.pingpong.representation.ConstantsAspect;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;

import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.INKFResponse;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;
import org.ten60.netkernel.layer1.representation.ByteArrayAspect;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

/** Bi-directional serialisation/parsing of an IAspectConstants to binary
 * for loading and saving of settings
 */
public class PresetTransreptor extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( (aFrom.hasAspect(IAspectConstants.class) && aTo.isAssignableFrom(ByteArrayAspect.class))
			||   (aFrom.hasAspect(IAspectReadableBinaryStream.class) && aTo.isAssignableFrom(ConstantsAspect.class)) );
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	
		Class to = context.getThisRequest().getAspectClass();
		if (to.isAssignableFrom(ByteArrayAspect.class))
		{	//serialize
			IAspectConstants from = (IAspectConstants)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectConstants.class);
			Properties p=new Properties();
			for (Iterator i=from.getNames(); i.hasNext(); )
			{	String name=(String)i.next();
				String value = from.getValue(name).toString();
				p.setProperty(name, value);
			}
			ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
			p.store(baos, "pingpong preset");
			baos.flush();
			INKFResponse resp=context.createResponseFrom(new ByteArrayAspect(baos));
			context.setResponse(resp);
		}
		else
		{	//parse
			IAspectReadableBinaryStream from = (IAspectReadableBinaryStream)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectReadableBinaryStream.class);
			Properties p = new Properties();
			p.load(from.getInputStream());
			ConstantsAspect aspect = new ConstantsAspect();
			for (Enumeration e=p.keys(); e.hasMoreElements(); )
			{	String name=(String)e.nextElement();
				String value = p.getProperty(name);
				Number n;
				if (aspect.getValue(name) instanceof Integer)
				{	n=new Integer(value);
				}
				else
				{	n=new Float(value);
				}
				aspect.setValue(name, n);
			}
			INKFResponse resp = context.createResponseFrom(aspect);		
			context.setResponse(resp);
		}
	}
}