<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/nvp">
        <batch>
			<sql>
				SELECT @hostname:=value FROM system WHERE system.setting='WWWHOSTNAME';
			</sql>
			<sql>
				INSERT INTO blogxter.blogs VALUES
				(
					null,
					'<xsl:value-of select="name"/>',
					'<xsl:value-of select="descr"/>',
					<xsl:value-of select="owner"/>,
					NOW(),
					'private',
					'live',
					@hostname
				);

				<!--Blogs columns
				id		    MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
				name		VARCHAR(255),
				descr		TEXT,
				owner		MEDIUMINT UNSIGNED,
				created		TIMESTAMP(14),
				status		ENUM("live", "offline", "closed")
				-->
			</sql>
			<sql>
				SELECT @userid:=users.id FROM users WHERE users.id=<xsl:value-of select="owner"/>;
			</sql>
			<sql>
				SELECT @blogid:=id FROM blogs WHERE name='<xsl:value-of select="name"/>' AND owner=<xsl:value-of select="owner"/>;
			</sql>
			<sql>
				SELECT @admingroupid:=id from blogxter.groups where name='admin';
			</sql>
			<sql>
				SELECT @editorgroupid:=id from blogxter.groups where name='editor';
			</sql>
			<sql>
				SELECT @authorgroupid:=id from blogxter.groups where name='author';
			</sql>
			<sql>
				SELECT @membergroupid:=id from blogxter.groups where name='member';
			</sql>
			<sql>
				INSERT INTO affiliations VALUES (@userid, @admingroupid, @blogid, 'approved');
			</sql>
			<sql>
				INSERT INTO affiliations VALUES (@userid, @editorgroupid, @blogid, 'approved');
			</sql>
			<sql>
				INSERT INTO affiliations VALUES (@userid, @authorgroupid, @blogid, 'approved');
			</sql>
			<sql>
				INSERT INTO affiliations VALUES (@userid, @membergroupid, @blogid, 'approved');
			</sql>
			<!--Default Settings-->
			<sql>
				INSERT INTO blogxter.settings VALUES (@sysadminblog, 'PUBLIC', 0);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'MEMBERLISTING', 1);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'COMMENTS', 0);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'TRACKBACKS', 0);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'NOTIFICATIONCOMMENTS', 0);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'NOTIFICATIONENTRIES', 0);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'PUBLISHCOUNT', 5);
			</sql>
			<sql>
				INSERT INTO blogxter.settings VALUES (@blogid, 'POLLAUTH', 0);
			</sql>
		</batch>
    </xsl:template>

</xsl:stylesheet> 
