<?xml version="1.0" encoding="UTF-8" ?>
<!--
<comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<xsl:template match="/blog">
		<rss version="2.0">
			<channel>
				<title><xsl:value-of select="meta/results/row/name"/></title>
				<link><xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/publish/<xsl:value-of select="meta/results/row/id"/></link>  <!--Need to pass as param!-->
				<description><xsl:value-of select="meta/results/row/descr"/></description>
				<language>en-us</language>
				<ttl>60</ttl>
			
				<xsl:apply-templates select="entries/results/row"/>
			</channel>
		</rss>
    </xsl:template>
	
	<!--
	///////////////////////
	//Match each entry item
	///////////////////////
	-->
	<xsl:template match="row">
		
		<item>
			<title><xsl:value-of select="title"/></title>
			<link><xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/entry?publicid=<xsl:value-of select="publicid"/></link>
			<guid isPermaLink="true"><xsl:value-of select="/blog/meta/results/row/hostname"/>blogxter/entry?publicid=<xsl:value-of select="publicid"/></guid>
			<description>
				<xsl:value-of select="summary"/>
			</description>
			<generator>NetKernel Standard Edition v2.2 Blogxter v1.0.0</generator>
			<pubDate>
				<xsl:value-of select="substring(dateDayName, 1,3)"/>,
				<xsl:text> </xsl:text>
				<xsl:call-template name="addzero">
					<xsl:with-param name="n" select="dateDayOfMonth"/>
				</xsl:call-template>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring(dateMonthName, 1, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="dateYear"/>
				<xsl:text> </xsl:text>
				<xsl:call-template name="addzero">
					<xsl:with-param name="n" select="timeHour"/>
				</xsl:call-template>:<xsl:call-template name="addzero">
					<xsl:with-param name="n" select="timeMinute"/>
				</xsl:call-template>:00
				<xsl:text> </xsl:text>GMT
			</pubDate>
		</item>
	</xsl:template>
	

	<xsl:template name="toText">
		<xsl:param name="entry"/>
		<xsl:param name="text"/>
		<xsl:if test="string-length($text) &lt; 100 and descendant::*">
			<xsl:call-template name="toText">
				<xsl:with-param name="entry" select="descendant::*"/>
				<xsl:with-param name="text" select="concat($text,' ', $entry/text())"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$text"/>
	</xsl:template>
		
	<!--
	//////////////////////////////////////////////
	//Utility to add Zero to a number less than 10
	//////////////////////////////////////////////
	-->
	<xsl:template name="addzero">
		<xsl:param name="n"/>
		<xsl:if test="$n &lt; 10">0</xsl:if><xsl:value-of select="$n"/>
	</xsl:template>
	
</xsl:stylesheet> 
