<?xml version="1.0" encoding="UTF-8" ?>

<!--
   <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="/nvp">
		<xsl:variable name="blogid" select="blogid"/>
        <batch>
			<sql>
				DELETE FROM affiliations WHERE blogid=<xsl:value-of select="$blogid"/>;
			</sql>
			<sql>
				SELECT @admingroupid:=id from blogxter.groups where name='admin';
			</sql>
			<sql>
				SELECT @editorgroupid:=id from blogxter.groups where name='editor';
			</sql>
			<sql>
				SELECT @authorgroupid:=id from blogxter.groups where name='author';
			</sql>
			<sql>
				SELECT @membergroupid:=id from blogxter.groups where name='member';
			</sql>
			<xsl:for-each select="item">
				<xsl:choose>
					<xsl:when test="substring-before(.,',')='admin'">
						<sql>
							INSERT INTO affiliations VALUES (<xsl:value-of select="substring-after(.,',')"/> , @admingroupid, <xsl:value-of select="$blogid"/> , 'approved');
						</sql>
					</xsl:when>
					<xsl:when test="substring-before(.,',')='editor'">
						<sql>
							INSERT INTO affiliations VALUES (<xsl:value-of select="substring-after(.,',')"/> , @editorgroupid, <xsl:value-of select="$blogid"/> , 'approved');
						</sql>
					</xsl:when>
					<xsl:when test="substring-before(.,',')='author'">
						<sql>
							INSERT INTO affiliations VALUES (<xsl:value-of select="substring-after(.,',')"/> , @authorgroupid, <xsl:value-of select="$blogid"/> , 'approved');
						</sql>
					</xsl:when>
					<xsl:when test="substring-before(.,',')='member'">
						<sql>
							INSERT INTO affiliations VALUES (<xsl:value-of select="substring-after(.,',')"/> , @membergroupid, <xsl:value-of select="$blogid"/> , 'approved');
						</sql>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="delete">
				<sql>
					DELETE FROM affiliations WHERE userid=<xsl:value-of select="."/> AND blogid=<xsl:value-of select="$blogid"/>;
				</sql>
			</xsl:for-each>
		</batch>
    </xsl:template>

</xsl:stylesheet> 
