/*
 * NetKernelAdapter2.java
 *
 * Created on 06 July 2005, 09:49
 */

package org.ten60.netkernel.xforms.adapter;

import org.chiba.adapter.*;
import org.chiba.util.*;
import org.chiba.xml.xforms.*;
import org.chiba.xml.xforms.exception.XFormsException;

import java.util.*;
import java.io.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.aspect.*;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.w3c.dom.*;

/**
 *
 * @author  pjr
 */
public class NetKernelAdapter2 extends AbstractChibaAdapter
{	
	public static final String NKF_REQUEST_HELPER="org.ten60.netkernel.nkf.helper";
	private Map mCBContext = null;
	private InteractionHandler handler;
	private INKFConvenienceHelper context=null;
	private ChibaBean mChibaBean=null;
	
	//processing-phase handling - signals to UIGenerator
    private static final String INIT_PHASE = "init";
    private static final String SESSION_PHASE = "session";
    private static final String SUBMIT_PHASE = "submit";
	private String mPhase;
	
	//Submission/Instance Arguemnt Prefixes
	private static final String BASE_INSTANCE_PARAM_NAME = "instance-";
	private static final int BASE_INSTANCE_PARAM_NAME_LEN =
		BASE_INSTANCE_PARAM_NAME.length();
	private static final String BASE_SUBMISSION_ACTION_PARAM_NAME =
		"submission-action-";
	private static final int BASE_SUBMISSION_ACTION_PARAM_NAME_LEN =
		BASE_SUBMISSION_ACTION_PARAM_NAME.length();
	
	/** Creates a new instance of NetKernelAdapter2 */
	public NetKernelAdapter2(INKFConvenienceHelper aHelper)
	{	mCBContext=new HashMap();
		context=aHelper;
	}
	
	public void executeHandler() throws XFormsException
	{	this.handler.execute();
	}
	
	public void init() throws org.chiba.xml.xforms.exception.XFormsException
	{	try
		{	mChibaBean = createXFormsProcessor();
			mChibaBean.setContext(mCBContext);
			mChibaBean.setBaseURI(context.getCWU());
			IAspectString formsa=(IAspectString)context.sourceAspect("this:param:operand", IAspectString.class);
			setXForms(new ByteArrayInputStream(formsa.getString().getBytes()));
			mChibaBean.init();
			
			//Process Submission/Instance URI Arguments
			Iterator it=context.getThisRequest().getArguments();
			while(it.hasNext())
			{	String key=(String)it.next();
				if (key.startsWith(BASE_INSTANCE_PARAM_NAME)) {
					String instanceID =	key.substring(BASE_INSTANCE_PARAM_NAME_LEN);
					String instanceURI = context.getThisRequest().getArgument(key);
					mChibaBean.setInstanceURI(instanceID, instanceURI);
				} else if (key.startsWith(BASE_SUBMISSION_ACTION_PARAM_NAME))
				{	String submissionID = key.substring(BASE_SUBMISSION_ACTION_PARAM_NAME_LEN);
					String submissionURI = context.getThisRequest().getArgument(key);
					mChibaBean.setSubmissionURI(submissionID, submissionURI);
				}				
			}
			handler=new NetKernelRequestHandler(mChibaBean);
		}
		catch(Exception e)
		{	throw new XFormsException(e);
		}
		finally
		{	context=null;
		}
	}
	
	public void shutdown() throws XFormsException
	{	mChibaBean.shutdown();
	}
	
	public Document getXMLContainer() throws XFormsException
	{	return mChibaBean.getXMLContainer();
	}
	
	public Node getXForms() throws XFormsException
	{	//org.apache.xml.serialize.DOMSerializerImpl ds=new org.apache.xml.serialize.DOMSerializerImpl();
		//return ds.writeToString(getXMLContainer());
		return getXMLContainer();
	}
	
	/**
     * gets a context property from Chiba's context hashmap.
     *
     * @param key
     * @return a context property from Chiba's context hashmap.
     */
    public Object getContextProperty(String key) {
        return mCBContext.get(key);
    }

    /**
     * stores a context property into Chiba's context hashmap.
     *
     * @param key the key to associate with val
     * @param val the value object to store
     */
    public void setContextProperty(String key, Object val) {
        mCBContext.put(key, val);
    }
	
	/**
     * Instructs the application environment to forward the given response.
     *
     * @param response a map containing at least a response stream and optional
     *                 header information.
     */
    public void forward(Map response) {
        mChibaBean.getContext().put(this.SUBMISSION_RESPONSE, response);
    }

    /**
     * returns a Map object containing a forward uri. this is used by the 'load' action
     *
     * @return a Map object containing a forward uri
     */
    public Map getForwardMap() {
        return (Map) mChibaBean.getContext().get(this.SUBMISSION_RESPONSE);
    }
	
	public void dispatch(org.chiba.adapter.ChibaEvent chibaEvent) throws org.chiba.xml.xforms.exception.XFormsException
	{
	}
	
}
