/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NKFXFormsAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.8 $
  Last Modified: $Date: 2006/01/19 11:18:33 $
 *****************************************************************************/

package org.ten60.netkernel.xforms.accessor;

import org.apache.log4j.MDC;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.xforms.representation.NetKernelAdapterAspect;
import org.ten60.netkernel.xforms.adapter.*;
import org.ten60.netkernel.xforms.connector.*;
import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import java.util.*;
/**
 *
 * @author  pjr
 */
public class NKFXFormsAccessor extends NKFAccessorImpl
{
	
	/** Creates a new instance of NKFXFormsAccessor */
	public NKFXFormsAccessor()
	{	super(4, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	ClassLoader cl=Thread.currentThread().getContextClassLoader();
		MDC.put("URI", context.getCWU());
		try
		{	Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
			NetKernelAdapter2 nka=null;
			IURRepresentation result = null;
			IURRepresentation main = null;
			HashMap parts = new HashMap(3);

			if(context.getThisRequest().getActiveType().equals("buildXForm"))
			{	nka=new NetKernelAdapter2(context);
				nka.setContextProperty(NetKernelAdapter2.NKF_REQUEST_HELPER, context);
				nka.init();
				nka.setContextProperty(NetKernelAdapter2.NKF_REQUEST_HELPER, null);
			}
			else
			{	IURRepresentation opt = context.source("this:param:operator");
				if (opt.hasAspect(NetKernelAdapterAspect.class))
				{	NetKernelAdapterAspect nkaa = (NetKernelAdapterAspect) opt.getAspect(NetKernelAdapterAspect.class);
					nka = nkaa.getNetKernelAdapter();
				}
				else if (opt.hasAspect(IAspectMultipart.class))
				{	IAspectMultipart mp =(IAspectMultipart) opt.getAspect(IAspectMultipart.class);
					IURRepresentation part=mp.getPartWithName("netkerneladapter");
					if(part!=null)
					{		NetKernelAdapterAspect nkaa = (NetKernelAdapterAspect) part.getAspect(NetKernelAdapterAspect.class);
							nka = nkaa.getNetKernelAdapter();
					}
				}
				if (nka == null) throw new Exception("Must supply a ChibaBean XForm as operator");

				nka.setContextProperty(NetKernelAdapter2.NKF_REQUEST_HELPER, context);
				nka.executeHandler();
				nka.setContextProperty(NetKernelAdapter2.NKF_REQUEST_HELPER, null);
				
				Map m=nka.getForwardMap();
				
				if(m!=null)
				{	String forwardURI=(String)m.get(NKDummySubmissionDriver.NK_FORWARD_URI);
					main=new MonoRepresentationImpl(new AlwaysExpiredMeta("text/plain", 4), new StringAspect("forwardPayload"));
					parts.put( 
							"uri",
							new MonoRepresentationImpl(new AlwaysExpiredMeta("text/plain", 4), new StringAspect(forwardURI))
						);
					DOMXDA dxa=(DOMXDA)m.get(NKDummySubmissionDriver.NK_FORWARD_PAYLOAD);
					parts.put( 
							"document",
							new MonoRepresentationImpl(new AlwaysExpiredMeta("text/xml", 4), new DOMXDAAspect(dxa))
						);
					result = MultiPartAspect.create(main, parts);
				}
			}
			if(result==null)
			{	main =	DOMXDAAspect.create(new AlwaysExpiredMeta("text/xml", 16), new DOMXDA(nka.getXMLContainer()));
				parts.put( 
						"netkerneladapter",
						new MonoRepresentationImpl(new AlwaysExpiredMeta("application/xforms", 4), new NetKernelAdapterAspect(nka))
					);
				result=MultiPartAspect.create(main, parts);
			}
			INKFResponse resp=context.createResponseFrom(result);
			context.setResponse(resp);
		}
		finally
		{	Thread.currentThread().setContextClassLoader(cl);
			MDC.remove("URI");
		}
	}
}
