/******************************************************************************
 * (c) Copyright 2002-2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: wsdlGenerator.java,v $
 * Version:       $Name:  $ $Revision: 1.7 $
 * Last Modified: $Date: 2004/08/04 16:56:50 $
 *****************************************************************************/

package org.ten60.netkernel.ws.wsdl.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURRepresentation;
import org.ten60.netkernel.ws.soap.util.SOAPEnv;
import org.ten60.netkernel.ws.soap.server.*;
import org.ten60.netkernel.ws.soap.aspect.*;
import org.ten60.netkernel.xml.util.*;
import java.net.*;
import java.util.*;
import java.io.*;


/**
 * Generate wsdl document from SOAPServiceMap entry
 * @author  pjr
 */
public class wsdlGenerator extends XAccessor {
    
    private static final String ARG_CONFIG="config";
    
    public wsdlGenerator()
    {	declareArgument(SOAPEnv.ARG_ENDPOINT, true, false);
	declareArgument(ARG_CONFIG, true, false);
	declareThreadSafe();
    }
    
    protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
    {	IURRepresentation result=null;
	IAspectSOAPServerConfig cfga=(IAspectSOAPServerConfig)aHelper.getResource(aHelper.getURI(ARG_CONFIG), IAspectSOAPServerConfig.class).getAspect(IAspectSOAPServerConfig.class);
	SOAPServerConfig cfg=cfga.getSOAPServerConfig();
	String endpoint=aHelper.getURI(SOAPEnv.ARG_ENDPOINT).toString();
	if(cfg.hasWSDL(endpoint))
	{  //Serve service specified WSDL resource
	    result=aHelper.getResource(URI.create(cfg.getWSDL(endpoint)), IURAspect.class);
	    //Need to resolve all <import...> statements.
	}
	else //Dynamically Generate
	{
	    
	    List ports=cfg.getServicePorts(endpoint);
	    if(ports.size()==0) throw new Exception("No service registered for the endpoint");

	    StringBuffer sb=new StringBuffer(2048);
	    sb.append("<definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\" ");
	    sb.append("xmlns:s0=\""+endpoint+".wsdl"+"\" ");
	    sb.append("xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" ");
	    sb.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
	    sb.append("targetNamespace=\""+endpoint+".wsdl"+"\" ");
	    sb.append("name=\""+cfg.getServiceName(endpoint)+"\" >");   
	    
	    //message
	    DOMXDA types=new DOMXDA(XMLUtils.getInstance().newDocument(), false);
	    types.appendPath("/", "types", null);
	    HashMap targetns=new HashMap();
	    int scount=0;
	    Iterator i=ports.iterator();
	    while(i.hasNext())
	    {   SOAPServicePort port=(SOAPServicePort)i.next();
		sb.append("<message name=\""+port.getName()+"OpInput\" >");
		    //Add schema ref
		    MessageStruct ms=port.getMessageIn();
		    if(ms.getSchema()!=null)
		    {	DOMXDA schema=new DOMXDA(aHelper.getXResource(URI.create(ms.getSchema())).getReadOnlyDocument());
			if(!schema.isTrue("/xsd:schema/@targetNamespace")) throw new Exception("Schema "+ms.getSchema()+" must declare target namespace");
			types.append(schema, "/", "/types");
			String nsprefix="xsd"+(++scount);
			targetns.put(nsprefix, schema.getText("/xsd:schema/@targetNamespace", false));
			sb.append("<part name=\"Body\" element=\""+nsprefix+":"+ms.getElement()+"\"/>");
		    }
		    else
		    {	DOMXDA schema=generateLooseSchema(ms.getElement(),++scount);
			if(!schema.isTrue("/xsd:schema/@targetNamespace")) throw new Exception("Schema "+ms.getSchema()+" must declare target namespace");
			types.append(schema, "/", "/types");
			String nsprefix="xsd"+scount;
			targetns.put(nsprefix, schema.getText("/xsd:schema/@targetNamespace", false));
			sb.append("<part name=\"Body\" element=\""+nsprefix+":"+ms.getElement()+"\"/>");
		    }
		sb.append("</message>");
		sb.append("<message name=\""+port.getName()+"OpOutput\" >");
		    //Add schema ref
		    ms=port.getMessageOut();
		    if(ms.getSchema()!=null)
		    {	DOMXDA schema=new DOMXDA(aHelper.getXResource(URI.create(ms.getSchema())).getReadOnlyDocument());
			if(!schema.isTrue("/xsd:schema/@targetNamespace")) throw new Exception("Schema "+ms.getSchema()+" must declare target namespace");
			types.append(schema, "/", "/types");
			String nsprefix="xsd"+(++scount);
			targetns.put(nsprefix, schema.getText("/xsd:schema/@targetNamespace", false));
			sb.append("<part name=\"Body\" element=\""+nsprefix+":"+ms.getElement()+"\"/>");
		    }
		    else
		    {	DOMXDA schema=generateLooseSchema(ms.getElement(),++scount);
			if(!schema.isTrue("/xsd:schema/@targetNamespace")) throw new Exception("Schema "+ms.getSchema()+" must declare target namespace");
			types.append(schema, "/", "/types");
			String nsprefix="xsd"+scount;
			targetns.put(nsprefix, schema.getText("/xsd:schema/@targetNamespace", false));
			sb.append("<part name=\"Body\" element=\""+nsprefix+":"+ms.getElement()+"\"/>");
		    }
		sb.append("</message>");
	    }
	    
	    //portType
	    i=ports.iterator();
	    while(i.hasNext())
	    {   SOAPServicePort port=(SOAPServicePort)i.next();
		sb.append("<portType name=\""+port.getName()+"SOAP"+"\" >");
		    sb.append("<operation name=\""+port.getName()+"Op"+"\" >");
			sb.append("<input message=\"s0:"+port.getName()+"OpInput\" />");
			sb.append("<output message=\"s0:"+port.getName()+"OpOutput\" />");
		    sb.append("</operation>");
		sb.append("</portType>");
	    }
	    
	    //portbindings
	    i=ports.iterator();
	    while(i.hasNext())
	    {   SOAPServicePort port=(SOAPServicePort)i.next();
		sb.append("<binding name=\""+port.getName()+"SOAP"+"\" type=\"s0:"+port.getName()+"SOAP"+"\" >");
		sb.append("<soap:binding style=\""+(port.isDocMode()? "document" : "rpc")+"\" transport=\"http://schemas.xmlsoap.org/soap/http\" />");
		    sb.append("<operation name=\""+port.getName()+"Op"+"\" >");
			sb.append("<soap:operation soapAction=\""+port.getAction()+"\" style=\"document\"/>");
			sb.append("<input>");
			    sb.append("<soap:body use=\"literal\" />");
			sb.append("</input>");
			sb.append("<output>");
			    sb.append("<soap:body use=\"literal\" />");
			sb.append("</output>");
		    sb.append("</operation>");
		sb.append("</binding>");
	    }
	    
	    //service
	    sb.append("<service name=\""+cfg.getServiceName(endpoint)+"Service"+"\">");
	    i=ports.iterator();
	    while(i.hasNext())
	    {	SOAPServicePort port=(SOAPServicePort) i.next();
		sb.append("<port name=\""+port.getName()+"SOAP"+"\" binding=\"s0:"+port.getName()+"SOAP"+"\" >");
		sb.append("<soap:address location=\""+endpoint+"\"/>");
		sb.append("</port>");
	    }
	    sb.append("</service>");
	    
	    
	    sb.append("</definitions>");
	    
	    DOMXDA wsdl=new DOMXDA(XMLUtils.getInstance().parse(new StringReader(sb.toString())), false);
	    //Append Types to WSDL
	    wsdl.insertBefore(types, "/","/definitions/message[1]");
	    
	    //add types namespace mappings
	    Iterator j=targetns.keySet().iterator();
	    while(j.hasNext())
	    {	String nsprefix=(String)j.next();
		String ns=(String)targetns.get(nsprefix);
		wsdl.declareNS("/definitions", nsprefix, ns);
	    }
	    
	    result= DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml",16), wsdl);
	}
	return result;
    }
    
    private DOMXDA generateLooseSchema(String element, int index) throws Exception
    {	StringBuffer sb=new StringBuffer(512);
	sb.append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2000/10/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" ");
	sb.append("targetNamespace=\"http://ten60.org/wsdl-generator1/tns"+index+"\" ");
        sb.append("elementFormDefault=\"qualified\">");
	sb.append("<xsd:element name=\""+element+"\">");
	sb.append("<xsd:complexType mixed=\"true\"> ");
        sb.append("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\"> ");
        sb.append("<xsd:any minOccurs=\"0\" maxOccurs=\"unbounded\" />");
        sb.append("</xsd:choice>");
        sb.append("<xsd:anyAttribute/>");
	sb.append("</xsd:complexType>");
	sb.append("</xsd:element>");
	sb.append("</xsd:schema>");
	return new DOMXDA(XMLUtils.getInstance().parse(new StringReader(sb.toString())), false);
    }
}