/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SOAPServer.java,v $
 * Version:       $Name:  $ $Revision: 1.8 $
 * Last Modified: $Date: 2004/08/04 16:56:50 $
 *****************************************************************************/
package org.ten60.netkernel.ws.soap.server;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.meta.MetaImpl;
import org.ten60.netkernel.ws.soap.util.SOAPEnv;
import org.ten60.netkernel.ws.soap.aspect.*;
import java.net.*;
import java.util.*;


/**
 * <p>
 * SOAPServer - receives a "message" argument holding the SOAP message and a "endpoint"
 * argument holding the external service endpoint URI and if provided an "action" argument
 * holding the SOAP action URI.
 *<p>
 *<p>
 * The SOAPServer interrogates message header and body according to the SOAP 1.1/1.2 processing rules.
 * Headers which should be processed for a given actor/role are forwarded to internal processes based on
 * configuration rules.   If the actor/role is not the ultimate receiver the message is relayed to the next
 * service in the SOAP message chain.
 *</p>
 *
 * @author  pjr
 */
public class SOAPServer extends XAccessor
{   private static final String ARG_ENDPOINT="endpoint";
    private static final String ARG_MESSAGE="message";
    private static final String ARG_ACTION="action";
    private static final String ARG_CONFIG="config";
    private static final String CONFIG_URI="ffcpl:/etc/ConfigSOAPServer.xml";
    
    /** Creates a new instance of SOAPServer */
    public SOAPServer()
    {	declareArgument(ARG_ENDPOINT, true, true);
	declareArgument(ARG_MESSAGE, false, false);
	declareArgument(ARG_ACTION, false, true);
	declareArgument(ARG_CONFIG, false, true);
    }
    
    protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
    {	IAspectSOAPServerConfig cfga=(IAspectSOAPServerConfig)aHelper.getResource(aHelper.getURI(ARG_CONFIG), IAspectSOAPServerConfig.class).getAspect(IAspectSOAPServerConfig.class);
        SOAPServerConfig cfg=cfga.getSOAPServerConfig();
        String action=null;
        String endpoint=aHelper.getURI(ARG_ENDPOINT).toString();
        URI actionURI=aHelper.getURI(ARG_ACTION);
        if(actionURI!=null) action=actionURI.toString();
        else action="";
        SOAPServicePort port=cfg.getPort(endpoint,action);
        IURRepresentation result=null;
        if(port==null) throw new Exception("No port found for endpoint/action");
        if(port.isDocMode()) result=invokeService(aHelper, port);
        else result=invokeRPC(aHelper, port);
        return result;
    }
    
    private IURRepresentation invokeService(XAHelper aHelper, SOAPServicePort aPort) throws Exception
    {	XAHelperExtra extra=(XAHelperExtra)aHelper;
        extra.getRequest().getURI();
        HashMap map=new HashMap(1);
        //Build Service Invocation URI
        CompoundURIdentifier curi=new CompoundURIdentifier(new URIdentifier(aPort.getInternal()));
        //endpoint
        curi.addArg(
            ARG_ENDPOINT,
            aHelper.getURI(ARG_ENDPOINT).toString()
            );
        //message
        if(aHelper.getURI(ARG_MESSAGE)!=null)
        {    URIdentifier message=URIdentifier.getUnique("literal:param");
            curi.addArg(ARG_MESSAGE, message.toString());
            map.put(
            message,
            aHelper.getResource(aHelper.getURI(ARG_MESSAGE), IURAspect.class)
            );
        }
        //action
        if(aHelper.getURI(ARG_ACTION)!=null)
        {   curi.addArg(
            ARG_ACTION,
            aHelper.getURI(ARG_ACTION).toString()
            );
        }
        //Build Request
        URRequest req=new URRequest(
            curi.toURI(),
            null,
            extra.getRequest().getSession(),
            this.getModule(),
            URRequest.RQT_SOURCE,
            null,
            extra.getRequest(),
            IURAspect.class
            );
        //Add pass by value arguments
        Iterator i=map.keySet().iterator();
        while(i.hasNext())
        {   URIdentifier key=(URIdentifier)i.next();
            req.addArg(key, (IURRepresentation)map.get(key));
        }
        /*
         * Issue request and return result - may need to do SOAP complient checking here.
         * Currently this accessor is synchronous.
         */
        return getScheduler().requestSynch(req).getResource();
    }
    
    private IURRepresentation invokeRPC(XAHelper aHelper, SOAPServicePort aPort) throws Exception
    {	throw new Exception("RPC mode not supported yet");
    }
}