/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SOAPHTTPBindingClient.java,v $
 * Version:       $Name:  $ $Revision: 1.8 $
 * Last Modified: $Date: 2004/08/04 16:56:50 $
 *****************************************************************************/
package org.ten60.netkernel.ws.soap.client;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.util.Utils;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.meta.MetaImpl;
import org.ten60.netkernel.ws.soap.util.SOAPEnv;
import org.w3c.dom.*;
import java.net.*;
import java.io.*;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.methods.*;

/**
 * SOAP Service Invocation over HTTP - supports SOAP 1.1/SOAP 1.2
 * @author  pjr
 */
public class SOAPHTTPBindingClient extends XAccessor{
    
    private static final String SOAP_1_1="SOAPv1.1";
    private static final String SOAP_1_2="SOAPv1.2";
    
    private static final String ARG_ENDPOINT="endpoint";
    private static final String ARG_MESSAGE="message";
    private static final String ARG_ACTION="action";
    
    /** Creates a new instance of HTTPSOAPAccessor */
    public SOAPHTTPBindingClient()
    {	declareArgument(ARG_ENDPOINT, true, true);
	declareArgument(ARG_MESSAGE, true, false);
	declareArgument(ARG_ACTION, false, true);
    }
    
    protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
    {	IXAspect messageXA=aHelper.getXResource(aHelper.getURI("message"));
	Document mdom=messageXA.getReadOnlyDocument();
	Node n=mdom.getDocumentElement();
	String version=null;
	String envNamespace=n.getNamespaceURI();
	if(envNamespace.equals(SOAPEnv.SOAP_1_1_NAMESPACE))
	{   version=SOAP_1_1;
	}
	else if (envNamespace.equals(SOAPEnv.SOAP_1_2_NAMESPACE))
	{   version=SOAP_1_2;
	}
	else throw new Exception("Envelope namespace does not conform to a supported SOAP version (1.1/1.2)");
	return doHTTPRequest(messageXA.getXDA(), aHelper.getURI(ARG_ENDPOINT), version, aHelper.getURI(ARG_ACTION));
    }
 
    private IURRepresentation doHTTPRequest(IXDAReadOnly aMessage, URI aEndpoint, String aVersion, URI aAction) throws Exception
    {	URL endpoint=aEndpoint.toURL();
	HttpClient client = new HttpClient();
	PostMethod method = new PostMethod(endpoint.toString());
	
	if (aVersion.equals(SOAP_1_1))
	{   if(aAction==null) throw new Exception("No Action URI argument specified for SOAP 1.1 message");
	    method.setRequestHeader("SOAPAction", "\""+aAction.toString()+"\"");
	    method.setRequestHeader("Content-Type", "text/xml");
	    method.setRequestHeader("Accept", "text/xml");
	}
	else if(aVersion.equals(SOAP_1_2))
	{   method.setRequestHeader("Accept", "application/soap+xml text/xml");
	    StringBuffer contentType=new StringBuffer(100);
	    contentType.append("application/soap+xml");
	    if(aAction!=null)
	    {	contentType.append("; action=\"");
		contentType.append(aAction.toString());
		contentType.append("\"");
	    }
	    method.setRequestHeader("Content-Type", contentType.toString());
	}
	else throw new Exception("Unsupported SOAP version: "+aVersion);
	
	
	//Set post body to SOAP message
	StringWriter sw=new StringWriter(5000);
	aMessage.serialize(sw,false);
	ByteArrayInputStream bais=new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
	method.setRequestBody(bais);
	//Make request
	int statusCode = -1;
          // We will retry up to 3 times.
          for (int attempt = 0; statusCode == -1 && attempt < 3; attempt++)
	  {
              try
	      {	// execute the method.
                statusCode = client.executeMethod(method);
              } 
	      catch (HttpRecoverableException e)
	      {	System.err.println("A recoverable exception occurred with HTTP request, retrying.  " + e.getMessage());
              } 
          }
          // Check that we didn't run out of retries.
          if (statusCode == -1)
	  { throw new Exception ("Failed to recover from HTTP request exception.");
          }	
	//Read Response
	ByteArrayOutputStream baos=new ByteArrayOutputStream();
	BufferedInputStream is= new BufferedInputStream(method.getResponseBodyAsStream());
	Utils.pipe(is, baos);
	
	method.releaseConnection();
	
	IURMeta meta = new MetaImpl(method.getResponseHeader("Content-Type").getValue(), 0, 64);
	ByteArrayAspect aspect = new ByteArrayAspect(baos);
	return new MonoRepresentationImpl( meta , aspect );
    }
}
