/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: wsExceptionToSOAPFault.java,v $
 * Version:       $Name:  $ $Revision: 1.9 $
 * Last Modified: $Date: 2004/08/04 16:56:50 $
 *****************************************************************************/
package org.ten60.netkernel.ws.soap.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.ws.soap.util.*;
import com.ten60.netkernel.util.NetKernelException;

import java.io.*;
import java.net.*;

/**
 * Convert a NetKernelException to a SOAP Fault.
 * @author  pjr
 */
public class wsExceptionToSOAPFault extends XAccessor
{
    /** Creates a new instance of wsHasSOAPFault */
    public wsExceptionToSOAPFault()
    {	declareArgument(SOAPEnv.ARG_MESSAGE, true, false);
        declareArgument("exception", true, false);
        declareArgument("actor", false, false);
        declareArgument("role", false, false);
        declareThreadSafe();
    }
    
    protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
    {	IXAspect mxa=(IXAspect)aHelper.getResource(aHelper.getURI(SOAPEnv.ARG_MESSAGE), IXAspect.class).getAspect(IXAspect.class);
        DOMXDA mdx=new DOMXDA(mxa.getReadOnlyDocument(), false);
        String soapNS=mdx.getDocument().getDocumentElement().getNamespaceURI();
        boolean SOAP11=soapNS.equals(SOAPEnv.SOAP_1_1_NAMESPACE);
        String envPrefix=mdx.getPrefix(soapNS);
        String bxp=Utils.replacePrefix("/$1:Envelope/$1:Body",envPrefix);
        mdx.delete(bxp+"/*");
        IXAspect exa=(IXAspect)aHelper.getResource(aHelper.getURI("exception"), IXAspect.class).getAspect(IXAspect.class);
        if(SOAP11)
        {   String base=Utils.replacePrefix("/$1:Envelope/$1:Body/$1:Fault", envPrefix);
            mdx.appendPath(bxp, envPrefix+":Fault", null );
            mdx.appendPath(base, "faultcode", envPrefix+":Server" );
            String id=exa.getXDA().getText("/ex/id",false);
            mdx.appendPath(base, "faultstring", id );
            mdx.appendPath(base, "detail", "");
            URI actor=aHelper.getURI("actor");
            if(actor!=null) mdx.appendPath(base, "actor", actor.toString());
            mdx.append(exa.getXDA(), "/ex", base+"/detail");
        }
        else
        {   mdx.appendPath(bxp, Utils.replacePrefix("$1:Fault/$1:Code/$1:Value", envPrefix), envPrefix+":Receiver" );
            mdx.appendPath(bxp+"/"+envPrefix+":Fault", Utils.replacePrefix("$1:Reason/$1:Text", envPrefix), "NetKernelException" );
            URI role=aHelper.getURI("role");
            if(role!=null) mdx.appendPath(bxp+"/"+envPrefix+":Fault",envPrefix+":Role", role.toString());
            mdx.appendPath(bxp+"/"+envPrefix+":Fault",envPrefix+":Detail", null);
            mdx.append(exa.getXDA(), "/ex", Utils.replacePrefix(bxp+"/$1:Fault/$1:Detail", envPrefix));
        }

        return DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml",4), mdx);
    }
    
}