/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XML_RDFSerializeTransreptor.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2005/07/22 14:02:53 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.transreptor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.rdf.jena.representation.*;
import org.ten60.netkernel.xml.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.hp.hpl.jena.rdf.model.*;
import java.io.*;
import org.ten60.netkernel.layer1.representation.*;

/**
 * RDF/XML Transreptor which reuses the active:jRDFParseXML accessor
 * @author  pjr
 */
public class XML_RDFSerializeTransreptor extends NKFTransreptorImpl
{
	
	/** Creates a new instance of XML_RDFParserTransreptor */
	public XML_RDFSerializeTransreptor()
	{
	}
	
	public boolean supports(com.ten60.netkernel.urii.IURRepresentation aFrom, Class aTo)
	{	return aFrom.hasAspect(IAspectJenaModel.class) && ( aTo.isAssignableFrom(IXAspect.class) || aTo.isAssignableFrom(IAspectBinaryStream.class));
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	Class aTo=context.getThisRequest().getAspectClass();
		INKFRequest req=context.createSubRequest();
		req.setURI("active:jRDFSerializeXML");
		req.addArgument("operand", context.source(INKFRequestReadOnly.URI_SYSTEM));
		if(aTo.isAssignableFrom(IXAspect.class))
		{	req.setAspectClass(IXAspect.class);
		}
		IURRepresentation result=context.issueSubRequest(req);
		INKFResponse resp=context.createResponseFrom(result);
		resp.setMimeType(context.source(INKFRequestReadOnly.URI_SYSTEM).getMeta().getMimeType());
		context.setResponse(resp);
	}
	
}
