/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: QueryTransreptor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2005/07/22 14:02:53 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.accessor.rdql;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.rdf.jena.representation.*;
import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import com.ten60.netkernel.urii.aspect.*;
import com.hp.hpl.jena.rdql.*;

/**
 * RDQL Query Transreptor which compiles a RDQL query string to a query object.
 * @author  pjr
 */
public class QueryTransreptor extends NKFTransreptorImpl
{
	
	/** Creates a new instance of QueryTransreptor */
	public QueryTransreptor()
	{
	}
	
	public boolean supports(com.ten60.netkernel.urii.IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(IAspectJenaQuery.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation aFrom=context.source(INKFRequestReadOnly.URI_SYSTEM);
		String mime=aFrom.getMeta().getMimeType();
		String query=null;
		if (mime.equals("text/xml") || mime.equals("application/xml") || aFrom.hasAspect(IAspectXDA.class))
		{	// must be a wrapped query
			IAspectXDA xa=(IAspectXDA)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectXDA.class);
			query=xa.getXDA().getText("/rdql", false);
		}
		else
		{	IAspectString sa=(IAspectString)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectString.class);
			query=sa.getString();
		}
		QueryAspect qa=new QueryAspect(new Query(query));
		INKFResponse resp=context.createResponseFrom(qa);
		resp.setCacheable();
		context.setResponse(resp);
	}
	
}
