/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SerializerAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2005/07/28 14:16:10 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.accessor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.rdf.jena.representation.*;
import org.ten60.netkernel.layer1.representation.ByteArrayAspect;
import java.io.*;

import com.hp.hpl.jena.rdf.model.*;

/**
 * An XML RDF Model Serializer
 * @author  pjr
 */
public class SerializerAccessor extends NKFAccessorImpl
{
	
	/** Creates a new instance of XMLParserAccessor */
	public SerializerAccessor()
	{	super(2, false, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IAspectJenaModel jma=(IAspectJenaModel)context.sourceAspect("this:param:operand", IAspectJenaModel.class);
		ByteArrayOutputStream baos=new ByteArrayOutputStream(2048);
		String type=context.getThisRequest().getActiveType();
		Model m=jma.getModelReadOnly();
		ModelLock lock=m.getModelLock();
		lock.enterCriticalSection(lock.READ);
		try
		{	if(type.equals("jRDFSerializeXML"))
			{	m.write(baos);
			}
			else if (type.equals("jRDFSerializeN3"))
			{	m.write(baos, "N3");
			}
			else if (type.equals("jRDFSerializeN-Triple"))
			{	m.write(baos, "N-TRIPLE");
			}
		}
		finally
		{	lock.leaveCriticalSection();			
		}
		ByteArrayAspect bas=new ByteArrayAspect(baos.toByteArray());
		INKFResponse resp=context.createResponseFrom(bas);
		resp.setCacheable();
		context.setResponse(resp);
	}
	
}
