/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ResolveXRLURIAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2005/09/28 09:20:11 $
 *****************************************************************************/
package org.ten60.docxter2;

import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;

import java.net.*;
/**
 * Resolve an xrl:scheme URI to an external URI (in canonical XML format)
 * @author  tab
 */
public class ResolveXRLURIAccessor extends NKFAccessorImpl
{
	
	/** Creates a new instance of XRLResolveURI */
	public ResolveXRLURIAccessor()
	{	super(0,true,INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{
		ILinkTableAspect linkTable;
		if (context.getThisRequest().getArgument("operator")!=null)
		{	linkTable = (ILinkTableAspect)context.sourceAspect("this:param:operator",ILinkTableAspect.class);
		}
		else
		{	linkTable = (ILinkTableAspect)context.sourceAspect(GTPUtils.DEFAULT_LINKS.toString(),ILinkTableAspect.class);
		}
		
		String operandURI=context.getThisRequest().getArgument("operand");
		String name;
		if (operandURI.startsWith("xrl:"))
		{	name=operandURI.substring(4);
		}
		else
		{	IXDAReadOnly operand=((IAspectXDA)context.sourceAspect("this:param:operand",IAspectXDA.class)).getXDA();
			name=operand.getText(".",true).substring(4);
		}


		Link link=linkTable.getLinkWithName(name);
		if (link==null)
		{	throw new NKFException("Link Not Found",null,name.toString());
		}
		URI base=linkTable.getBasePath();
		URI linkURI=URI.create(link.getExternal());
		String result="<uri>"+XMLUtils.escape(base.resolve(linkURI).getPath().toString())+"</uri>";
		INKFResponse resp=context.createResponseFrom(new StringAspect(result));
		resp.setMimeType("text/xml");
	}	
}
