/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: LinkTable.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2005/09/16 16:12:13 $
 *****************************************************************************/
package org.ten60.docxter2;

import org.ten60.netkernel.xml.xda.*;
import java.util.*;
import java.net.URI;
/**
 * LinkTable
 * @author  tab
 */
public class LinkTable implements ILinkTableAspect
{
	private final Map mNameToLink;
	private final Map mPathToLink;
	private URI mBasePath;
	
	/** Creates a new instance of LinkTable */
	public LinkTable(IXDAReadOnly aLinks) throws XPathLocationException
	{	mNameToLink = new HashMap();
		mPathToLink = new HashMap();
		try
		{	String basepathString = aLinks.getText("@basepath", true);
			mBasePath = URI.create(basepathString);
		} catch (XPathLocationException e)
		{	mBasePath = null;
		}
		
		IXDAReadOnlyIterator i = aLinks.readOnlyIterator("/links/link");
		while (i.hasNext())
		{	i.next();
			String name=null, internal=null, external=null, args=null;
			try
			{	name = i.getText("name", true);
			} catch (XPathLocationException e)
			{;}
			try
			{	internal = i.getText("int", true);
			} catch (XPathLocationException e)
			{;}
			try
			{	external = i.getText("ext", true);
				if (mBasePath!=null && external.startsWith("/"))
				{	if (external.length()>1)
					{	external = external.substring(1);
					}
					else
					{	external=".";
					}
					URI extURI = URI.create(external);
					URI rel = mBasePath.resolve(extURI);
					external = rel.getPath();
				}
			} catch (XPathLocationException e)
			{;}
			try
			{	args = i.getText("args", true);
			} catch (XPathLocationException e)
			{;}
			Link link = new Link(name,internal,external,args);
			if (name!=null)
			{	mNameToLink.put(name,link);
			}
			if (external!=null)
			{	mPathToLink.put(external,link);
			}
		}
	}
	
	public Link getLinkWithName(String aName)
	{	return (Link)mNameToLink.get(aName);
	}
	
	public Link getLinkWithExternalPath(String aPath)
	{	return (Link)mPathToLink.get(aPath);
	}
	
	public URI getBasePath()
	{	return mBasePath;
	}
	
}