package org.ten60.ura.xslt2;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.NKFEntityResolver;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.apache.xml.serializer.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import net.sf.saxon.*;
import net.sf.saxon.om.*;
import net.sf.saxon.tinytree.*;
import net.sf.saxon.trans.*;
import net.sf.saxon.xpath.*;

/**
 * Creates a TinyTree Aspect from any XML
 * @author maw
 */
public class XML2TinyTree extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aTo.isAssignableFrom(TinyTreeAspect.class) );
	}
	
	public void transrepresent(INKFConvenienceHelper aContext) throws NetKernelException
	{	try
		{	Source aSource=null;
			IURRepresentation aResource = aContext.source(INKFRequestReadOnly.URI_SYSTEM);
			SAXParserFactory spf=SAXParserFactory.newInstance();
			if(aResource.hasAspect(IAspectReadableBinaryStream.class))
			{	IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)aResource.getAspect(IAspectReadableBinaryStream.class);				
				XMLReader reader= spf.newSAXParser().getXMLReader();
				reader.setEntityResolver(new NKFEntityResolver(aContext));
				InputSource is= new InputSource(rbs.getInputStream());
				is.setSystemId(aContext.getThisRequest().getURI());
				aSource= new SAXSource(reader, is);
			}
			else if(aResource.hasAspect(IAspectBinaryStream.class))
			{	ByteArrayOutputStream baos=new ByteArrayOutputStream(2048);
				IAspectBinaryStream bs=(IAspectBinaryStream)aResource.getAspect(IAspectBinaryStream.class);
				bs.write(baos);
				XMLReader reader= spf.newSAXParser().getXMLReader();
				reader.setEntityResolver(new NKFEntityResolver(aContext));
				InputSource is= new InputSource(new ByteArrayInputStream(baos.toByteArray()));
				is.setSystemId(aContext.getThisRequest().getURI());
				aSource= new SAXSource(reader, is);
			}
			if(aSource==null)
			{	IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)aContext.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IAspectReadableBinaryStream.class);
				XMLReader reader= spf.newSAXParser().getXMLReader();
				reader.setEntityResolver(new NKFEntityResolver(aContext));
				InputSource is= new InputSource(rbs.getInputStream());
				is.setSystemId(aContext.getThisRequest().getURI());
				aSource= new SAXSource(reader, is);
			}

			XPathEvaluator eval = new XPathEvaluator(XMLToXSLTransformer.getSharedSaxonConfiguration());
            NodeInfo       tree = eval.setSource(aSource);

			IURAspect    aspect = new TinyTreeAspect(tree);
			
			aContext.createResponseFrom(aspect).setCreationCost(32);
		} catch (Exception e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in XML2TinyTree");
			nke.addCause(e);
			throw nke;
		}
	}
}
