package org.ten60.ura.xslt2;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.xml.xda.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.layer1.representation.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.apache.xml.serializer.*;
import javax.xml.transform.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import net.sf.saxon.*;
import net.sf.saxon.om.*;
import net.sf.saxon.tinytree.*;
import net.sf.saxon.trans.*;
import net.sf.saxon.xpath.*;

/**
 * Creates a readable BinaryStream from a TinyTree Aspect
 * @author maw
 */
public class TinyTree2BinaryStream extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(TinyTreeAspect.class) && (aTo.isAssignableFrom(IAspectBinaryStream.class) || aTo.isAssignableFrom(IAspectReadableBinaryStream.class)));
	}
	
	public void transrepresent(INKFConvenienceHelper aContext) throws NetKernelException
	{	try
		{	TinyTreeAspect tta = (TinyTreeAspect)aContext.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,TinyTreeAspect.class);

			ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);

			net.sf.saxon.TransformerFactoryImpl tfi =new net.sf.saxon.TransformerFactoryImpl(XMLToXSLTransformer.getSharedSaxonConfiguration());
            TransformerFactory tfactory = tfi.newInstance();
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(tta.getTree(), new StreamResult(baos));

			IURAspect aspect = new ByteArrayAspect(baos.toByteArray());
			
			aContext.createResponseFrom(aspect).setCreationCost(32);
		} catch (Exception e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in TinyTree2BinaryStream");
			nke.addCause(e);
			throw nke;
		}
	}
}
