/*
 * OutputURIResolverImpl.java
 *
 * Created on 26 May 2004, 17:30
 */

package org.ten60.ura.xslt2;

import net.sf.saxon.*;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import java.io.*;
import java.net.URI;
/**
 *
 * @author  pjr
 */
public class OutputURIResolverImpl implements OutputURIResolver {
    
    private String mScratchURI;
    private URI mCWU;
    
    /** Creates a new instance of OutputURIResolverImpl */
    public OutputURIResolverImpl(String aScratchURI, String aCWU)
    {	if(aCWU==null)
		{	aCWU="ffcpl:/";
		}
		mCWU=URI.create(aCWU);
		String path=mCWU.getPath();
		if(path==null)
		{	mScratchURI=aScratchURI;
		}
		else
		{	URI s=URI.create(aScratchURI);
			mScratchURI=s.resolve(path.substring(1)).toString();
		}
    }
    
    public void close(javax.xml.transform.Result result) throws javax.xml.transform.TransformerException
    {
    }
    
    public javax.xml.transform.Result resolve(String str, String str1) throws javax.xml.transform.TransformerException
    {	URI href=URI.create(str);
	if(href.isAbsolute())
	{   if(href.getScheme().equals("ffcpl"))
	    {	URI rel=href.relativize(URI.create("ffcpl:/"));
		href=URI.create(mScratchURI);
		href=href.resolve(rel);
	    }
	}
	else
	{   if(str1==null) str1=mScratchURI;
	    URI base=URI.create(str1);
	    if(base.getScheme().equals("file"))
	    {	href=base.resolve(href);
	    }
	    else if(base.getScheme().equals("ffcpl"))
	    {	URI rel=href.relativize(URI.create("ffcpl:/"));
		base=URI.create(mScratchURI);
		base=base.resolve(rel);
		href=base.resolve(href);
	    }
	}
	File f=new File(href);
	f.getParentFile().mkdirs();
	StreamResult sr=new StreamResult(f);
	return sr;
    }
    
}
