/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ScriptCompiler.java,v $
  Version:       $Name:  $ $Revision: 1.10 $
  Last Modified: $Date: 2004/10/06 10:25:56 $
 *****************************************************************************/
package org.ten60.netkernel.script.transreptor;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.mozilla.javascript.EvaluatorException;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;

import org.ten60.netkernel.script.representation.IScriptEngine;
import org.ten60.netkernel.xml.representation.IAspectXDA;
import org.ten60.netkernel.xml.xda.IXDAReadOnly;
/**
 * Transreptor to take a raw script and produce a 
 * (potentially) compiled script aspect
 * @author  tab
 */
public class ScriptCompiler extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return (aFrom.hasAspect(IAspectXDA.class) || aFrom.hasAspect(IAspectBinaryStream.class)) 
			&& IScriptEngine.class.isAssignableFrom(aTo);
	}
	
	public void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation aFrom=context.source(INKFRequestReadOnly.URI_SYSTEM);
		try
		{	String script;

			String mime = aFrom.getMeta().getMimeType();
			if (mime.equals("text/xml") || mime.equals("application/xml") || aFrom.hasAspect(IAspectXDA.class))
			{	// must be a wrapped script
				if (!aFrom.hasAspect(IAspectXDA.class))
				{	aFrom = context.source(INKFRequestReadOnly.URI_SYSTEM,IAspectXDA.class);
				}
				IXDAReadOnly from = ((IAspectXDA)aFrom.getAspect(IAspectXDA.class)).getXDA();
				script = from.getText(".", false);
			}
			else
			{	// must be a raw script
				if (!aFrom.hasAspect(IAspectString.class))
				{	aFrom = context.source(INKFRequestReadOnly.URI_SYSTEM,IAspectString.class);
				}
				script = ((IAspectString)aFrom.getAspect(IAspectString.class)).getString();
			}

			// now create script aspect
			IScriptEngine engine = (IScriptEngine)context.getThisRequest().getAspectClass().newInstance();
			ClassLoader cl=this.getClass().getClassLoader();
			engine.initialise(script,context,cl);
			INKFResponse response = context.createResponseFrom(engine);
			response.setCreationCost(8);
			context.setResponse(response);
		}
		catch (EvaluatorException e)
		{	String location="line:"+e.getLineNumber()+" column: "+e.getColumnNumber()+" line: "+e.getLineSource();
			NetKernelException nke = new NetKernelException("Failed to compile script",e.getClass().getName()+": "+e.getMessage(),location);
			throw nke;
		}
	}
	
}