/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: JavaScriptEngine.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2005/06/02 12:24:32 $
 *****************************************************************************/
package org.ten60.netkernel.script.engine.javascript;

import org.mozilla.javascript.*;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.script.representation.IScriptEngine;
import com.ten60.netkernel.urii.aspect.IAspectString;
import java.util.*;
import java.lang.reflect.*;
import java.io.Reader;

/**
 * Implementation of JS engine
 * @author  tab
 */
public class JavaScriptEngine implements IScriptEngine
{
	private Script mScript;
	private ClassLoader mLastClassLoader;
	
	public void execute(INKFConvenienceHelper aContext, ClassLoader aClassLoader) throws Exception
	{
		Context ctx=Context.enter();
		if (mLastClassLoader==null || !mLastClassLoader.equals(aClassLoader))
		{	// reuse same classloader if it hasn't changed- big performance boost
			mLastClassLoader = aClassLoader;
		}
		ctx.setApplicationClassLoader(mLastClassLoader);
		Thread.currentThread().setContextClassLoader(mLastClassLoader);
		try
		{   
			Scriptable scope =new ImporterTopLevel(ctx);
	
			//wrap a dynamic proxy around the context to add the import interface
			Class[] classes=new Class[]{INKFConvenienceHelper.class, INKFBasicHelper.class, JavaScriptImporter.class};
			InvocationHandler h = new JavaScriptContextHandler(aContext,ctx,scope);
			Object dynamicContext = Proxy.newProxyInstance(aClassLoader, classes, h);
			Scriptable sp=ctx.toObject(dynamicContext, scope);
			scope.put("context", scope, sp );
			
			for (Iterator i=aContext.getThisRequest().getArguments(); i.hasNext(); )
			{	String argName = (String)i.next();
				if (argName.startsWith("import"))
				{	Reader script=((IAspectString)aContext.sourceAspect("this:param:"+argName,IAspectString.class)).getReader();
					ctx.evaluateReader(scope,script, argName, 1, null);
				}
			}
			mScript.exec(ctx,scope);
		}
		catch (WrappedException e)
		{	String message="line:"+e.getLineNumber()+" column: "+e.getColumnNumber();
			NKFException nke = new NKFException("Wrapped exception in Javascript",null,message);
			nke.addCause(e.getWrappedException());
			throw nke;
		}
		catch (EcmaError e)
		{	String message="line:"+e.getLineNumber()+" column: "+e.getColumnNumber();;
			NKFException nke = new NKFException("EcmaError in Javascript",e.getMessage(),message);
			throw nke;
		}
		finally
		{   Context.exit();
		}
	}
	
	public void initialise(String aScript, INKFConvenienceHelper aContext, ClassLoader aClassLoader) throws Exception
	{	
		Context ctx=Context.enter();
		ctx.setOptimizationLevel(1);
		try
		{   
			ctx.initStandardObjects();
			mScript = ctx.compileString(aScript, "", 1, null);
		}
		finally
		{   Context.exit();	    
		}
	}	
}