/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: FindUpdatesAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2005/06/13 09:04:03 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer.update;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;

import java.net.*;
import java.util.*;
import org.w3c.dom.*;
/**
 *	Process dependencies needed on adding new modules
 * @author  tab
 */
public class FindUpdatesAccessor extends XAccessor
{
	public FindUpdatesAccessor()
	{	declareArgument(XAccessor.OPERATOR, true, false); // netkernel:module
		declareArgument(XAccessor.PARAMETER, true, false); // modules.xml server list
	}
	

	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IXDAReadOnly serverList = aHelper.getParameter().getXDA();
		IXDAReadOnly modules = aHelper.getOperator().getXDA();
		
		// build template result document
		Document d = XMLUtils.newDocument();
		DOMXDA xda = new DOMXDA(d,false);
		xda.appendPath("/", "modules", null);
		
		// build selected list
		for (IXDAReadOnlyIterator i = serverList.readOnlyIterator("/modules/module"); i.hasNext(); )
		{	i.next();
			Version v = new Version(i.getText("version", true));
			String uriString = i.getText("uri",true);
			Version upgradeMinVersion = null, upgradeMaxVersion = null;
			Version deployedMaxVersion = null;
			
			// see if it is deployed
			for (IXDAReadOnlyIterator j = modules.readOnlyIterator("/modules/module[identity/uri='"+uriString+"']"); j.hasNext(); )
			{	j.next();
				Version v2 = new Version(j.getText("identity/version",true));
				if (deployedMaxVersion==null || deployedMaxVersion.isLessThan(v2))
				{	deployedMaxVersion=v2;
				}
			}
			
			
			if (deployedMaxVersion!=null)
			{	for (IXDAReadOnlyIterator j = modules.readOnlyIterator("/modules/module/raw/module/mapping/import[uri='"+uriString+"']"); j.hasNext(); )
				{	j.next();
					try
					{	Version v2 = new Version(j.getText("version-min",true));
						if (upgradeMinVersion==null ||upgradeMinVersion.isGreaterThan(v2))
						{	upgradeMinVersion = v2;
						}
					} catch (XPathLocationException e) {;}
					try
					{	Version v2 = new Version(j.getText("version-max",true));
						if (upgradeMaxVersion==null ||upgradeMaxVersion.isLessThan(v2))
						{	upgradeMaxVersion = v2;
						}
					} catch (XPathLocationException e) {;}
				}
			}
			boolean canUpgrade = ( deployedMaxVersion!=null && deployedMaxVersion.isLessThan(v)
									&& (upgradeMinVersion==null || v.isGreaterOrEqualThan(upgradeMinVersion))
									&& (upgradeMaxVersion==null || v.isLessOrEqualThan(upgradeMaxVersion))
								);
			if (canUpgrade)
			{	xda.append(i, ".", "/modules");
				xda.appendPath("/modules/module[last()]", "editable", "true");
			}
		}
			
		IURRepresentation result = DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml", 64), xda);
		return result;
	}
}