<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/module">
		<module>
			<xsl:for-each select="*">
				<xsl:choose>
					<xsl:when test="name()='mapping'">
						<xsl:call-template name="mapping"/>
					</xsl:when>
					<xsl:when test="name()='identity'">
						<xsl:call-template name="identity"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</module>
    </xsl:template>
	
	<xsl:template name="identity">
		<identity>
			<xsl:for-each select="*">
				<xsl:choose>
					<xsl:when test="name()='version'">
						<version>
						<xsl:call-template name="parseVersion">
							<xsl:with-param name="version" select="text()"/>
						</xsl:call-template>
						</version>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</identity>
	</xsl:template>
	
	<xsl:template name="parseVersion">
		<xsl:param name="version"/>
		<xsl:choose>
			<xsl:when test="contains($version,'.')"><xsl:value-of select="substring-before($version,'.')"/>.<xsl:call-template name="parseVersion">
				<xsl:with-param name="version" select="substring-after($version,'.')"/></xsl:call-template>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="number($version)+1"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="mapping">
		<mapping>
			<xsl:for-each select="*">
				<xsl:variable name="uri" select="uri/text()"/>
				<xsl:choose>
					<xsl:when test="name()='import' and $param/modules/module[uri=$uri]">
						<xsl:comment>Install wizard removed import [<xsl:value-of select="uri/text()"/>]</xsl:comment>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</mapping>
	</xsl:template>

</xsl:stylesheet> 
