/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: FilterNewModulesAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/08/05 10:39:42 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer.add;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.util.Utils;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;

import java.net.*;
import java.util.*;
import java.io.*;
import org.w3c.dom.*;
/**
 *	Filter the list of modules from the server to exclude ones
 * that we already have and possibly ones that are not the latest versions
 * @author  tab
 */
public class FilterNewModulesAccessor extends XAccessor
{
	public FilterNewModulesAccessor()
	{	declareArgument(XAccessor.OPERAND, true, false); // server module list
		declareArgument(XAccessor.PARAMETER, true, false); // /nvp/old flag to include non-latest versions
		declareArgument(XAccessor.OPERATOR, true, false); // netkernel:module
	}

	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IXDAReadOnly operand = aHelper.getOperand().getXDA();
		IXDAReadOnly modules = aHelper.getOperator().getXDA();
		IXDAReadOnly param = aHelper.getParameter().getXDA();
		boolean includeOld = param.isTrue("/nvp/old");
		boolean includeLib = param.isTrue("/nvp/lib");
		DOMXDA result = new DOMXDA(XMLUtils.newDocument(), false);
		result.appendPath("/","modules", null);
		
		Map newestVersions;
		if (!includeOld)
		{	// find newest versions
			newestVersions = new HashMap();
			for (IXDAReadOnlyIterator i = operand.readOnlyIterator("/modules/module"); i.hasNext(); )
			{	i.next();
				String uri = i.getText("uri", true);
				Version version = new Version(i.getText("version", true));
				Version existing = (Version)newestVersions.get(uri);
				if (existing==null || existing.isLessThan(version))
				{	newestVersions.put(uri, version);
				}
			}
		}
		else
		{	newestVersions=null;
		}
		
		for (IXDAReadOnlyIterator i = operand.readOnlyIterator("/modules/module"); i.hasNext(); )
		{	i.next();
			String uri = i.getText("uri", true);
			if (uri.equals(com.ten60.netkernel.container.Container.NETKERNEL_URN))
			{	break; // cannot install kernel, only upgrate
			}
			boolean lib = i.isTrue("type='library'");
			if (!lib || includeLib )
			{
				if (includeOld && !haveModule(i,modules))
				{	result.append(i, ".", "/modules");
				}
				else if (!includeOld)
				{	
					Version version = new Version(i.getText("version", true));
					Version newest = (Version)newestVersions.get(uri);
					if (version.equals(newest) && !haveModule(i,modules))
					{	result.append(i, ".", "/modules");
					}
				}
			}
		}
		
		MetaImpl meta = new MetaImpl("text/xml", 0, 0);
		return DOMXDAAspect.create(meta, result);
	}
	
	private boolean haveModule(IXDAReadOnly aModule, IXDAReadOnly aModules) throws Exception
	{	String uri = aModule.getText("uri", true);
		String version = new Version(aModule.getText("version", true)).toString(3);
		return aModules.isTrue("/modules/module[identity/uri='"+uri+"' and identity/version='"+version+"']");
	}
	
}