<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
		
	<xsl:param name="param"/>
	<xsl:param name="guest"/>
	<xsl:variable name="disabled">false</xsl:variable>
	
    <xsl:template match="/">
	<div>
		<h2>Bug-a-matic</h2>
		<style  type="text/css">
		.table { background:#ddddff; }
		.block { background:#eeeeff; padding:3px; }
		.label { font-weight:bold; }
		.error { font-weight:bold; color:red; }
		</style>
		
			<xsl:if test="$guest/b='t'">
				<div style="background-color: #bbbbff;">
					<b>Sorry as a guest you are not permitted to add new bugs - please register as a member</b>
				</div>
			</xsl:if>
		<form action="[[xrl:new_bug_process]]" xrl:resolve="action" method="POST">
			<input type="hidden" name="call" value="process_new_bug"/>
			<table class="table"  cellspacing="4" border="0">
				
				<tr>
				<td valign="top">
					<span class="label">product:</span><br/>
					<select class="select" id="product" name="product" size="8" maxlength="30" onchange="javascript:newProduct()"/>
				</td>
				<td name="top">
					<span class="label">version:</span><br/>
					<select class="select" id="version" name="version" size="8" maxlength="30" onchange="javascript:newVersion()"/>
				</td>
				<td valign="top">
					<span class="label">component:</span><br/>
					<select class="select" id="component" name="component" size="8" maxlength="30" onchange="javascript:newComponent()"/>
				</td>
				<td valign="top" colspan="4">
					<table cellspacing="4" border="0">
						<tr><td width="300"><span class="label">Section Summary</span></td></tr>
						<tr><td class="block" id="product-desc"/></tr>
						<tr><td class="block" id="version-desc"/></tr>
						<tr><td class="block" id="component-desc"/></tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<div style="float: right;">
					<b>Title</b>
					</div>
				</td>
				<td colspan="10">
					<textarea name="title" style="width:100%; height:30px;"/>
				</td>
			</tr>
			<tr>
				<td>
					<div style="float: right;">
					<b>Description</b>
					</div>
					<table style="margin-top: 100px;">
				<tr>
					<td ><b>Severity</b></td><td colspan="3">
					<select name="bug_severity">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="'normal'"/>
							<xsl:with-param name="options" select="$param/selections/bug_severity/option"/>
						</xsl:call-template>
					</select>
				</td>
				</tr>
				<tr>
				<td><b>OS</b></td><td>
					<select name="op_sys">
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="op_sys"/>
							<xsl:with-param name="options" select="$param/selections/op_sys/option"/>
						</xsl:call-template>
					</select>
				</td>
				</tr>
				<tr>
				<td><b>JVM Version</b></td><td>
					<input name="jvm_version" style="width: 50px;">
						<xsl:attribute name="value"><xsl:value-of select="jvm_version"/></xsl:attribute>
					</input>
				</td>
				</tr>
				</table>
				</td>
				<td colspan="10">
					<textarea name="short_desc" style="width: 100%; height: 200px;">
					<xsl:value-of select="short_desc"/>
					</textarea>
				</td>
			</tr>
			<tr>
				<td/>
				<td colspan="10">
				
				</td>
				</tr>
				<tr>
				<td ><b>File URI</b></td><td colspan="3">
					<input name="buggy_file" style="width:300px;">
						<xsl:attribute name="value"><xsl:value-of select="buggy_file"/></xsl:attribute>
					</input>
				</td>
				</tr>
				<tr><td colspan="4">
					<input type="submit" value="Submit">
						<xsl:if test="$guest/b='t'">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
					</input>
				</td></tr>
			</table>
		</form>
	
	
		<xrl:include href="xrl:javascript_products"/>
	
		<script LANGUAGE="JavaScript">
		<xsl:comment>
		productIndex=0;
		versionIndex=0;
		componentIndex=0;


		function populateProduct()
		{	var select = document.getElementById( 'product' );
			select.options.length=0;
			for (i = 0; i!=data.length; i++)
			{	var productId = data[i][0];
				var option = new Option(productId);
				select.options[i]=option;
			}
			select.selectedIndex=productIndex;
			descProduct();
			populateVersion();
		}
		function descProduct()
		{	var p = data[productIndex];
			desc = label("product")+p[0]+br()+label("description")+p[1]+br()+label("URN")+p[2];
			document.getElementById( 'product-desc' ).innerHTML=desc;
		}

		function populateVersion()
		{	var select2 = document.getElementById( 'version' );
			select2.options.length=0;
			var versions = data[productIndex][3];
			for (j = 0; j!=versions.length; j++)
			{	var versionId = versions[j][0];
				var option = new Option(versionId);
				select2.options[j]=option;
			}
			select2.selectedIndex=versionIndex;
			descVersion();
			populateComponent();
		}
		function descVersion()
		{	var v = data[productIndex][3][versionIndex];
			desc = label("version")+v[0]+br()+label("description")+v[1];
			document.getElementById( 'version-desc' ).innerHTML=desc;
		}

		function populateComponent()
		{	var select3 = document.getElementById( 'component' );
			select3.options.length=0;
			var components = data[productIndex][3][versionIndex][2];
			for (k = 0; k!=components.length; k++)
			{	var componentId = components[k][1];
				var option = new Option(componentId);
				option.value=components[k][0];
				select3.options[k]=option;
			}
			select3.selectedIndex=componentIndex;
			descComponent();
		}
		function descComponent()
		{	var c = data[productIndex][3][versionIndex][2][componentIndex];
			desc = label("component")+c[1]+br()+label("description")+c[2];
			document.getElementById( 'component-desc' ).innerHTML=desc;
		}

		function label(text)
		{	return "\u003cspan class=\u0027label\u0027\u003e"+text+": \u003c/span\u003e";
		}
		function br()
		{	return "\u003cbr/\u003e";
		}	

		function newProduct()
		{   productIndex = document.getElementById( 'product' ).selectedIndex;
			versionIndex=0;
			componentIndex=0;
			descProduct();
			populateVersion();
		}

		function newVersion()
		{   versionIndex = document.getElementById( 'version' ).selectedIndex;
			componentIndex=0;
			descVersion();
			populateComponent();
		}
		function newComponent()
		{   componentIndex = document.getElementById( 'component' ).selectedIndex;
			descComponent()
		}
		function init()
		{	populateProduct();
		}

		init();
		</xsl:comment>
		</script>
		
	</div>
    </xsl:template>
	
	<xsl:template name="bug">
		
	</xsl:template>
	
	<xsl:template name="selector">
		<xsl:param name="value"/>
		<xsl:param name="options"/>
			<xsl:for-each select="$options">
				<option>
					<xsl:attribute name="value">
						<xsl:value-of select="./@value"/>
					</xsl:attribute>
					<xsl:if test="./text() = $value">
						<xsl:attribute name="selected">true</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</option>
			</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet> 
