<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	<xsl:param name="param"/>
	<xsl:param name="guest"/>
	<xsl:variable name="noedit" select="not ( $guest/b='f' and /bug/@editable )"/>
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="bug/product/null"/>
			<xsl:apply-templates select="bug/product/results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 20px;">Bug id not found</div>
	</xsl:template>
		
	<xsl:template match="results">
		<h2>Edit Bug</h2>	
		<table wisth="700">
			<xsl:if test="$noedit">
			<tr bgcolor="#bbbbff"><td>
			<xsl:choose>
				<xsl:when test="$guest/b='t'">
						<b>Please note: Guest users cannot modifiy bugs.</b>
				 </xsl:when>
				 <xsl:when test="$noedit">
						<b>You are not a member of this product group and cannot update this bug.</b>
				 </xsl:when>
			 </xsl:choose>
			 </td></tr>
			</xsl:if>
			<xsl:apply-templates select="row"/>
		</table>
		<a xrl:resolve="href">
			<xsl:attribute name="href">
				[[xrl:bug_activity]]?id=<xsl:value-of select="row/id"/>
			</xsl:attribute>
		View activity for this bug
		</a><br/>
		<xsl:if test="$guest/b='f'">
		<a xrl:resolve="href">
			<xsl:attribute name="href">
				[[xrl:process_subscription]]?id=<xsl:value-of select="row/id"/>
			</xsl:attribute>
			Subscribe to this bug
		</a>
		</xsl:if>
		<h2>Comments</h2>
		<style type="text/css">
				<xsl:comment>
				p	{font-size: 8px;}
				</xsl:comment>
		</style>
		<xsl:for-each select="/bug/comments/results/row">
			<xsl:variable name="who" select="who"/>
			<div style="font-size: 9px; font-weight: bold;">At <xsl:value-of select="changed"/><xsl:text> </xsl:text><xsl:value-of select="/bug/user/results/row[id=$who]/login"/> commented</div>
			<xsl:copy-of select="descr/*"/>
		</xsl:for-each>
		<xsl:if test="$guest/b='f'">
			<form action="[[xrl:process_comment]]" xrl:resolve="action" method="POST">
				<input type="hidden" name="id">
					<xsl:attribute name="value">
						<xsl:value-of select="row/id"/>
					</xsl:attribute>
				</input>
				<table>
					<tr>
					<td><textarea name="comment" style="width:400px; height:80px;"/><br/></td>
					</tr>
					<tr>
						<td><input type="submit" value="Submit Comment"/></td>
					</tr>
				</table>
			</form>
			<h3>File Attachments</h3>
			<xrl:include href="xrl:file_attachments"/>
			<script language="JavaScript">
			<xsl:comment>
			function showUpload()
			{	if (document.getElementById( 'upload' ).style.visibility=="visible")
				{	document.getElementById( 'upload' ).style.visibility= "hidden";
				}
				else
				{	document.getElementById( 'upload' ).style.visibility= "visible";
				}
			}
			</xsl:comment>
			</script>
			<a href="javascript:showUpload()">File Upload Form</a>
			<div id="upload" style="visibility:hidden;">
				<h3>Upload File</h3>
				<form action="xrl:process_upload" xrl:resolve="action" method="POST" enctype="multipart/form-data">
					<input type="hidden" name="id">
						<xsl:attribute name="value">
							<xsl:value-of select="row/id"/>
						</xsl:attribute>
					</input>
					<table>
					<tr>
						<td>Description</td>
						<td>
							<input name="description" style="width: 300px;"/>
						</td>
						<td>
							<label>Is Patch <input type="checkbox" name="ispatch"/></label>
						</td>
					</tr>
					<tr>
						<td>
						File
						</td>
						<td>
						<input name="file" type="file"/>
						</td>
					</tr>
					<tr>
						<td colspan="2">
						<input type="submit" value="Upload File"/>
						</td>
					</tr>
					</table>
				</form>
			</div>
		</xsl:if>

		<xrl:include href="xrl:javascript_products"/>
	
		<script language="JavaScript">
		<xsl:comment>
		productIndex=0;
		versionIndex=0;
		componentIndex=0;


		function populateProduct()
		{	var select = document.getElementById( 'product' );
			select.options.length=0;
			for (i = 0; i!=data.length; i++)
			{	var productId = data[i][0];
				var option = new Option(productId);
				select.options[i]=option;
			}
			select.selectedIndex=productIndex;
			populateVersion();
		}

		function populateVersion()
		{	var select2 = document.getElementById( 'version' );
			select2.options.length=0;
			var versions = data[productIndex][3];
			for (j = 0; j!=versions.length; j++)
			{	var versionId = versions[j][0];
				var option = new Option(versionId);
				select2.options[j]=option;
			}
			select2.selectedIndex=versionIndex;
			populateComponent();
		}

		function populateComponent()
		{	var select3 = document.getElementById( 'component' );
			select3.options.length=0;
			var components = data[productIndex][3][versionIndex][2];
			for (k = 0; k!=components.length; k++)
			{	var componentId = components[k][1];
				var option = new Option(componentId);
				option.value=components[k][0];
				select3.options[k]=option;
			}
			select3.selectedIndex=componentIndex;
		}

		function label(text)
		{	return "\u003cspan class=\u0027label\u0027\u003e"+text+": \u003c/span\u003e";
		}
		function br()
		{	return "\u003cbr/\u003e";
		}	

		function newProduct()
		{   productIndex = document.getElementById( 'product' ).selectedIndex;
			versionIndex=0;
			componentIndex=0;
			populateVersion();
		}

		function newVersion()
		{   versionIndex = document.getElementById( 'version' ).selectedIndex;
			componentIndex=0;
			populateComponent();
		}
		function newComponent()
		{   componentIndex = document.getElementById( 'component' ).selectedIndex;
		}
		function setValues(product,version,component)
		{	productIndex=getIndex(product,data);
			versionIndex=getIndex(version,data[productIndex][3]);
			componentIndex=getIndex(component,data[productIndex][3][versionIndex][2]);
		}
		function getIndex(name,array)
		{	for (i=0; i!=array.length; i++)
			{	var test=array[i][0];
				if (test==name)
				{	return i;
				}
			}
			return 0;
		}
		function init()
		{	setValues('<xsl:value-of select="row/name"/>', '<xsl:value-of select="row/version"/>', '<xsl:value-of select="row/component"/>');
			populateProduct();
		}

		//Call several times to make sure that Opera does it after layout!
		init();
		init();
		init();
		init();
		init();
		</xsl:comment>
		</script>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<form action="xrl:process_update_bug" xrl:resolve="action" method="POST">
			<table width="600" bgcolor="#ddddff">
				<tr>
				<td><b>BugID</b></td><td>
					<b><xsl:value-of select="id"/></b>
					<input type="hidden" name="call" value="update_bug"/>
					<input name="id" type="hidden">
						<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
					</input>
				</td>
				<td><b>Created</b></td><td>
					<input name="created" disabled="true">
						<xsl:attribute name="value"><xsl:value-of select="created"/></xsl:attribute>
					</input>
				</td>
				</tr>
				<tr>
				<td>
				<b>Ownership</b>
				</td>
				<td colspan="3">
					<xsl:variable name="reporter" select="reporter"/>
					<xsl:variable name="assigned_to" select="assigned_to"/>
					<xsl:variable name="qa_contact" select="qa_contact"/>
					<table>
					<tr>
					<td><span class="label">reporter:</span></td>
					<td>
					<xsl:variable name="reporter" select="reporter"/>
					<input name="reporter" style="width:50;" disabled="true">
						<xsl:attribute name="value">
							<xsl:value-of select="/bug/user/results/row[id=$reporter/text()]/login"/>
						</xsl:attribute>
					</input></td><td>
					<span class="label">email:</span>
					<xsl:if test="$guest/b='f'">
					<a>
						<xsl:attribute name="href">mailto://<xsl:value-of select="/bug/user/results/row[id=$reporter/text()]/email"/></xsl:attribute>
						<i><xsl:value-of select="/bug/user/results/row[id=$reporter/text()]/email"/></i>
					</a>
					</xsl:if>
					<input name="reporter" type="hidden" style="width:50;">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="value">
							<xsl:value-of select="/bug/user/results/row[id=$reporter/text()]/login"/>
						</xsl:attribute>
					</input>
					</td>
					</tr>
					<tr>
						<td><span class="label">assigned to:</span></td><td>
					
					<input name="assigned_to" style="width:50;" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="value">
							<xsl:value-of select="/bug/user/results/row[id=$assigned_to/text()]/login"/>
						</xsl:attribute>
					</input></td><td>
					<span class="label">email:</span>
					<xsl:if test="$guest/b='f'">
					<a>
						<xsl:attribute name="href">mailto://<xsl:value-of select="/bug/user/results/row[id=$assigned_to/text()]/email"/></xsl:attribute>
						<i><xsl:value-of select="/bug/user/results/row[id=$assigned_to/text()]/email"/></i>
					</a>
					</xsl:if>
					</td>
					</tr>
					<tr>
				
					<td><span class="label">QA contact:</span></td><td>
					<input name="qa_contact" style="width:50; padding-right:10;" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="value">
							<xsl:value-of select="/bug/user/results/row[id=$qa_contact/text()]/login"/>
						</xsl:attribute>
					</input></td><td>
					<span class="label">email:</span>
					<xsl:if test="$guest/b='f'">
						<a>
							<xsl:attribute name="href">mailto://<xsl:value-of select="/bug/user/results/row[id=$qa_contact/text()]/email"/></xsl:attribute>
							<i><xsl:value-of select="/bug/user/results/row[id=$qa_contact/text()]/email"/></i>
						</a>
					</xsl:if>
					
					</td>
					</tr>
					</table>
					</td>
				</tr>
			
				<tr>
				<td/>
				<td>
					<span class="label">product:</span>
					<select class="select" id="product" name="product" maxlength="30" onchange="javascript:newProduct()">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
					</select>
				</td>
				<td>
					<span class="label">version:</span>
					<select class="select" id="version" name="version" maxlength="30" onchange="javascript:newVersion()" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
					</select>
				</td>
				<td>
					<span class="label">component:</span>
					<select class="select" id="component" name="component" maxlength="30" onchange="javascript:newComponent()">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
					</select>
				</td>
				</tr>
				<tr>
				<td/>
				<td colspan="3">
					<span class="label">severity:</span>
					<select name="bug_severity" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="bug_severity"/>
							<xsl:with-param name="options" select="$param/selections/bug_severity/option"/>
						</xsl:call-template>
					</select>
					<span class="label">priority:</span>
					<select name="priority" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="priority"/>
							<xsl:with-param name="options" select="$param/selections/priority/option"/>
						</xsl:call-template>
					</select>
					<span class="label">status:</span>
					<select name="bug_status" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="bug_status"/>
							<xsl:with-param name="options" select="$param/selections/bug_status/option"/>
						</xsl:call-template>
					</select>
					<span class="label">confirmed:</span>
					<select name="confirmed">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="confirmed"/>
							<xsl:with-param name="options" select="$param/selections/confirmed/option"/>
						</xsl:call-template>
						
					</select>
				</td>
				</tr>
				<tr>
				<td><b>Title</b></td><td colspan="3">
					<textarea name="title" style="width: 100%; height: 50px;">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="title"/>
					</textarea>
				</td>
				</tr>
				<tr>
				<td ><b>Description</b></td><td colspan="3">
					<textarea name="short_desc" style="width: 100%; height: 200px;">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="short_desc"/>
					</textarea>
				</td>
				</tr>
				<tr>
				<td ><b>File URI</b></td><td colspan="3">
					<input name="buggy_file" style="width:100%;" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="value"><xsl:value-of select="buggy_file"/></xsl:attribute>
					</input>
				</td>
				</tr>
				<tr>
				<td/>
				<td colspan="10">
				<table>
				<tr>
				
				<td><span class="label">OS:</span>
					<select name="op_sys" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="op_sys"/>
							<xsl:with-param name="options" select="$param/selections/op_sys/option"/>
						</xsl:call-template>
					</select>
				</td>
				<td><span class="label">jvm:</span>
					<input name="jvm_version" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="value"><xsl:value-of select="jvm_version"/></xsl:attribute>
					</input>
						
				</td>
				</tr>
				</table>
				</td>
				</tr>
				
				<tr>
				<td ><b>Progress</b></td><td colspan="3">
					<textarea name="status_report" type="text" style="width: 100%; height: 50px;" >
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="status_report"/>
					</textarea>
					
				</td>
				</tr>
				<tr>
				<td/>
				<td colspan="10">
				<table>
				<tr>
				<td><span class="label">resolution:</span>
					<select name="resolution">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="selector">
							<xsl:with-param name="value" select="resolution"/>
							<xsl:with-param name="options" select="$param/selections/resolution/option"/>
						</xsl:call-template>
					</select>
					
					<span class="label">target:</span>
					<input name="target" style="width: 300px;">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="value"><xsl:value-of select="target"/></xsl:attribute>
					</input>
					
				</td>
				</tr>
				</table>
				</td>
				</tr>
				<tr><td colspan="4">
					<input type="submit" value="Update">
						<xsl:if test="$noedit">
							<xsl:attribute name="disabled">true</xsl:attribute>
						</xsl:if>
					</input>
				</td></tr>
				<tr><td colspan="5"/></tr>
			</table>
			</form>
		</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="selector">
		<xsl:param name="value"/>
		<xsl:param name="options"/>
			<xsl:for-each select="$options">
				<option>
					<xsl:attribute name="value">
						<xsl:value-of select="./@value"/>
					</xsl:attribute>
					<xsl:if test="./text() = $value/text()">
						<xsl:attribute name="selected">true</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</option>
			</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet> 
