<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	
	
	<xsl:template match="/">
		<div>
			<h3>Users</h3>	
			<xsl:apply-templates select="null"/>
			<xsl:apply-templates select="results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 10px;">No users yet</div>
	</xsl:template>
		
	<xsl:template match="results">
			<table>
				<tr bgcolor="#ccccff">
					<td><b>id</b>
					</td>
					<td><b>login</b>
					</td>
					<td><b>email</b>
					</td>
					<td><b>status</b>
					</td>
					<td><b>www</b>
					</td>
					<td/>
					<td></td>
				</tr>
				<xsl:apply-templates select="row"/>	
			</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<xsl:value-of select="firstname"/><xsl:text> </xsl:text><xsl:value-of select="lastname"/>
			
		</td>
		<td>
			<xsl:value-of select="login"/>
		</td>
		<td>
			<a  xrl:resolve="href">
				<xsl:attribute name="href">mailto:<xsl:value-of select="email"/></xsl:attribute>
				<xsl:value-of select="email"/>
			</a>
		</td>
		<td>
			<xsl:value-of select="status"/>
		</td>
		<td>
			<a  xrl:resolve="href">
				<xsl:attribute name="href"><xsl:value-of select="URL"/></xsl:attribute>
				<xsl:value-of select="URL"/>
			</a>
		</td>
		<td>
			<xsl:if test="admin=1">
				<span style="color:red;">admin</span>
			</xsl:if>
		</td>
		<td>

		</td>
		</tr>
	</xsl:template>
	
</xsl:stylesheet> 
