<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
	
	<xsl:param name="param"/>	
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="products/info/null"/>
			<xsl:apply-templates select="products/info/results"/>
			<form action="[[xrl:admin_process_add_affiliate]]" xrl:resolve="action" method="POST">
				<input name="login"/>
				<input type="hidden" name="productid">
					<xsl:attribute name="value">
						<xsl:value-of select="$param/nvp/id"/>
					</xsl:attribute>
				</input>
				<select name="role">
					<option disabled="true">admin</option>
					<option selected="true">qa</option>
					<option disabled="true">developer</option>
					<option disabled="true">member</option>
				</select>
				<input type="submit"/>
			</form>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 20px;">No affiliations assigned</div>
	</xsl:template>
		
	<xsl:template match="results">
		<h2>Affiliates</h2>	
		<table>
		<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<xsl:value-of select="name"/>
		</td>
		</tr>
		<tr>
			<td>
			<table>
				<xsl:for-each select="/products/user/results/row">
					<xsl:value-of select="id"/>
					<xsl:value-of select="login"/>
					<xsl:value-of select="email"/>
					<xsl:value-of select="role"/>
				</xsl:for-each>
			</table>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="selector">
		<xsl:param name="value"/>
		<xsl:param name="options"/>
			<xsl:for-each select="$options">
				<option>
					<xsl:attribute name="value">
						<xsl:value-of select="./@value"/>
					</xsl:attribute>
					<xsl:if test="./text() = $value/text()">
						<xsl:attribute name="selected">true</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="."/>
				</option>
			</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet> 
