<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	
	
	<xsl:template match="/">
		<div>
			<h3>Subscriptions</h3>	
			<xsl:apply-templates select="null"/>
			<xsl:apply-templates select="results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 10px;">You are not subscribed to any bugs</div>
	</xsl:template>
		
	<xsl:template match="results">
		<form action="[[xrl:update_subscriptions]]" xrl:resolve="action" method="GET">
			<input type="hidden" name="dummy" value="dummy"/>
			<table>
				<tr bgcolor="#ccccff">
					<td width="30"><b>id</b>

					</td>
					<td><b>date</b>
					</td>
					<td width="200"><b>title</b>

					</td>
					<td width="75"><b>status</b>

					</td>
					<td width="75"><b>priority</b>

					</td>
					<td/>
					<td><b>delete</b></td>
				</tr>
				<xsl:apply-templates select="row"/>	
			</table>
			<input type="submit" value="Update Subscriptions"/>
		</form>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
			<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
		<td>
			<a  xrl:resolve="href">
				<xsl:attribute name="href">[[xrl:edit_bug]]?id=<xsl:value-of select="id"/></xsl:attribute>
				<xsl:value-of select="id"/>
			</a>
			
		</td>
		<td>
			<xsl:value-of select="created"/>
		</td>
		<td>
			<xsl:value-of select="title"/>
		</td>
		<td >
			<xsl:value-of select="bug_status"/>
		</td>
		<td align="center">
			<xsl:value-of select="priority"/>
		</td>
		<td>
			<a style="font-size: 8px;" xrl:resolve="href">
				<xsl:attribute name="href">[[xrl:edit_bug]]?id=<xsl:value-of select="id"/></xsl:attribute>
				view
			</a>
		</td>
		<td>
			<input type="checkbox" name="delete">
				<xsl:attribute name="value">
					<xsl:value-of select="id"/>
				</xsl:attribute>
			</input>
		</td>
		</tr>
	</xsl:template>
	
</xsl:stylesheet> 
