<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : transform_bugs.xsl
    Created on : 11 May 2003, 13:21
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xrl="http://1060.org/xrl">
		
	<xsl:param name="param"/>
	
	<xsl:template match="/">
		<div>
			<xsl:apply-templates select="bug/attachment/null"/>
			<xsl:apply-templates select="bug/attachment/results"/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 10px;">No attachments</div>
	</xsl:template>
		
	<xsl:template match="results">
		<table>
			<tr bgcolor="#ccccff">
			<td>uploaded</td>
			<td>
				by
			</td>
			<td>filename</td>
			<td>description</td>
			<td>size (kB)</td>
			<td/>
		</tr>
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>
	
	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
				<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
			<td><xsl:value-of select="creation_ts"/></td>
			<td>
				<xsl:variable name="who" select="submitter"/>
				<xsl:value-of select="/bug/user/results/row[id=$who]/login"/>
			</td>
			<td><xsl:value-of select="filename"/></td>
			<td><xsl:value-of select="description"/></td>
			<td><xsl:value-of select="size"/></td>
			<td>
				<xsl:if test="$param/b = 'f'">
					<form method="POST" xrl:resolve="action">
						<xsl:attribute name="action">
							[[xrl:export_attachment]]<xsl:value-of select="filename"/>
						</xsl:attribute>
					<input type="hidden" name="id">
						<xsl:attribute name="value">
							<xsl:value-of select="id"/>
						</xsl:attribute>
					</input>
					<input type="hidden" name="mimetype">
						<xsl:attribute name="value">
							<xsl:value-of select="mimetype"/>
						</xsl:attribute>
					</input>
					<input type="submit" value="export"/>
					</form>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
		
</xsl:stylesheet> 
