<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_products.xsl
    Created on : 10 March 2004, 16:16
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
	<xsl:template match="/">
		<div>
			<h2>Components</h2>
			<a xrl:resolve="href">	
				<xsl:attribute name="href">
					[[xrl:admin_add_components]]?id=<xsl:value-of select="$param/nvp/id/text()"/>
				</xsl:attribute>
			update components</a>
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	
	<xsl:template match="null">
			<div style="font-size: 20px;">No Components</div>
	</xsl:template>
	
	<xsl:template match="results">
				<div>
					<table>
						<xsl:apply-templates select="row"/>
					</table>
				</div>
    </xsl:template>
	
	<xsl:template match="row">
			<tr>
				<td><xsl:value-of select="name"/></td>
				<td><xsl:value-of select="description"/></td>
				<td><xsl:value-of select="urn"/></td>
				<td><xsl:value-of select="version"/></td>
			</tr>
	</xsl:template>

</xsl:stylesheet>
