<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : nvp_to_updateComponents_batch.xsl
    Created on : 11 March 2004, 10:55
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/nvp">
		<sql>
			SELECT bugs.*, users.id AS userid FROM bugs, users, sessions
				WHERE
					sessions.token='<xsl:value-of select="$param/token/text()"/>'
					AND sessions.userid=users.id
					AND 
						( bugs.reporter=users.id OR bugs.qa_contact=users.id OR bugs.assigned_to=users.id )
					<xsl:if test="not ( all ) and not ( old )">
						AND bugs.bug_status&lt;&gt;'CLOSED'
					</xsl:if>
					<xsl:if test="not ( all ) and old">
						AND bugs.bug_status='CLOSED'
					</xsl:if>
					GROUP BY bugs.id
					<xsl:if test="orderby">
						ORDER BY <xsl:value-of select="orderby"/><xsl:text> </xsl:text><xsl:value-of select="direction"/>
					</xsl:if>
				;
			
		</sql>
    </xsl:template>

</xsl:stylesheet>
