<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_polls.xsl
    Created on : 29 November 2003, 09:26
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

    <xsl:template match="/">		
				<xsl:apply-templates />
	</xsl:template>
	
	<xsl:template match="null">
		<div/>
	</xsl:template>
	
	<xsl:key name="polls" match="row" use="id"/>
	
	<xsl:template match="results">
		<td style="border-left: 1px solid black;">
			<style type="text/css">
				.blog-poll-button {font-size: 80%;}
			</style>
			<div style="padding-left: 3px; width: 80px; padding-right: 3px;">
				<xsl:for-each select="row[count(. | key('polls', id)[1]) = 1]">
					<div style="font-size: 80%;">
						<xsl:value-of select="question"/>
					</div>	
					<form action="xrl:vote" xrl:resolve="action" method="POST">
						<input name="pollid" type="hidden">
							<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
						</input>	
						<xsl:for-each select="key('polls', id)">
							<label style="font-size: 80%;">
								<input type="radio" name="choice">
									<xsl:attribute name="value"><xsl:value-of select="choiceid"/></xsl:attribute>
									<xsl:if test="position()=1">
										<xsl:attribute name="checked">true</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="choice"/>
							</label>
						</xsl:for-each>
						<input type="submit" value="Vote" class="blog-poll-button" />
					</form>
					<form action="xrl:poll_result" xrl:resolve="action" method="POST">
						<input name="pollid" type="hidden">
							<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
						</input>	
						<input type="submit" value="Results" class="blog-poll-button" />
					</form>
				</xsl:for-each>
			</div>
		</td>
    </xsl:template>

</xsl:stylesheet> 
