<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : poll_to_xchart.xsl
    Created on : 17 November 2003, 11:44
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
		<xsl:variable name="total" select="/votes/total/results/row/total/text()"/>
		<chart>
		  <properties>
			<type>bar-stacked</type>
			<title><xsl:value-of select="/votes/q/results/row/question"/></title>
			<width>400</width>
			<height>300</height>
			<xAxisTitle>Answer</xAxisTitle>
			<yAxisTitle>Votes %</yAxisTitle>
			<xAxisLabels>
				<xsl:for-each select="/votes/a/results/row">
				<label><xsl:value-of select="choice"/></label>
				</xsl:for-each>
			</xAxisLabels>
		  </properties>
		  <data>
				<dataset color="c1c1d0aa" name="Votes">
					<xsl:for-each select="/votes/a/results/row">
					  <point>
						<xsl:attribute name="y">
							<xsl:value-of select="(100 * votes) div $total"/>
						</xsl:attribute>
						</point>
					</xsl:for-each>
				</dataset>
		  </data>
		</chart>
        
    </xsl:template>

</xsl:stylesheet> 
