<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : poll_to_xchart.xsl
    Created on : 17 November 2003, 11:44
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/">
		<xsl:variable name="total" select="/votes/total/results/row/total/text()"/>
		<xsl:variable name="max">
			<xsl:call-template name="maximum">
				<xsl:with-param name="param" select="/votes/a/results/row"/>
			</xsl:call-template>
	   </xsl:variable>
	   <xsl:variable name="size" select="count(/votes/q/results/row)"/>
	   
		<svg:svg
	   xmlns:svg="http://www.w3.org/2000/svg"
	   xmlns:xlink="http://www.w3.org/1999/xlink"
	   version="1.0"
	   x="0"
	   y="0"
	   width="{($size*35)+100}"
	   height="400"
	   id="svg602"
	   xml:space="preserve">
	   <svg:defs id="defs604" />
	   
	   <!--Set classes for first 10 bars-->
	   <svg:style type="text/css">
		 .bar1 {font-size:12;fill:#ff4444;fill-rule:evenodd;stroke:#000000;}
		 .bar2 {font-size:12;fill:#44ff44;fill-rule:evenodd;stroke:#000000;}
		 .bar3 {font-size:12;fill:#4444ff;fill-rule:evenodd;stroke:#000000;}
		 .bar4 {font-size:12;fill:#ff44ff;fill-rule:evenodd;stroke:#000000;}
		 .bar5 {font-size:12;fill:#44ffff;fill-rule:evenodd;stroke:#000000;}
		 .bar6 {font-size:12;fill:#ff44ff;fill-rule:evenodd;stroke:#000000;}
		 .bar7 {font-size:12;fill:#ff8888;fill-rule:evenodd;stroke:#000000;}
		 .bar8 {font-size:12;fill:#88ff88;fill-rule:evenodd;stroke:#000000;}
		 .bar9 {font-size:12;fill:#8888ff;fill-rule:evenodd;stroke:#000000;}
		 .bar10 {font-size:12;fill:#ff88ff;fill-rule:evenodd;stroke:#000000;}
	   </svg:style>
	   
	   <!--Apply Global Offset-->
	   
	   <svg:g transform="translate(50, 50)">
	   <!--Vertical Axis-->
				<svg:g
				   style="font-size:12;"
				   id="g634"><svg:path
				   d="M 0 0 L 0 200 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path605" /><svg:text
				   x="-16"
				   y="5.58274841"
				   style="font-weight:normal;stroke-width:1;font-family:helvetica;text-anchor:end;"
				   id="text617"><svg:tspan
				   id="tspan618"><xsl:value-of select="$max"/></svg:tspan></svg:text><svg:text
				   x="-16"
				   y="202.888"
				   style="font-weight:normal;stroke-width:1;font-family:helvetica;"
				   id="text620"><svg:tspan
				   id="tspan621">0</svg:tspan></svg:text><svg:text
				   x="-14"
				   y="104.425217"
				   style="font-weight:normal;stroke-width:1;font-family:Arial;text-anchor:end;"
				   id="text623"
				   xml:space="preserve"><svg:tspan
				   x="-14"
				   y="104.425217"
				   id="tspan639"><xsl:value-of select="$max div 2"/></svg:tspan></svg:text><svg:text
				   x="-16"
				   y="154.585144"
				   style="font-weight:normal;stroke-width:1;font-family:Arial;text-anchor:end;"
				   id="text626"
				   xml:space="preserve"><svg:tspan
				   x="-14"
				   y="154.585144"
				   id="tspan632"><xsl:value-of select="$max div 4"/></svg:tspan></svg:text><svg:text
				   x="-14"
				   y="54.9794922"
				   style="font-weight:normal;stroke-width:1;font-family:Arial;text-anchor:end;"
				   id="text634"
				   xml:space="preserve"><svg:tspan
				   x="-14"
				   y="54.9794922"
				   id="tspan637"><xsl:value-of select="3 * $max div 4"/></svg:tspan></svg:text><svg:path
				   d="M -5 150 L 0 150 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path641" /><svg:path
				   d="M -5 100 L 0 100 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path642" /><svg:path
				   d="M -5 50 L 0 50 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path643" /><svg:path
				   d="M -5 50 L 0 50 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path644" /><svg:path
				   d="M -5 0 L 0 0 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path645" /><svg:path
				   d="M -5 200 L 0 200 "
				   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
				   id="path646" />
				</svg:g>

				<!--Horizontal Axis-->
				<xsl:variable name="width" select="($size*35)+5"/>
				<svg:path
					style="font-size:12;fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1;"
					id="BASELINE"
					d="M 0 200 L {$width} 200"
				/>
				
				<!--Draw entries-->
				<xsl:for-each select="/votes/a/results/row">
					<xsl:variable name="v" select="votes"/>
					<xsl:variable name="x" select="((position()-1)*35)+5"/>
					<xsl:variable name="h" select="($v div $max)*200"/>
					<xsl:variable name="y" select="200- $h"/>
					<xsl:variable name="bar" select="concat('bar', position())"/>
					<svg:rect
						width="30"
						height="{$h}"
						y="{$y}"
						class="{$bar}"
						x="{$x}"
						id="BAR-{position()}"
					/>
						
					<xsl:variable name="lx" select="$x * 0.7"/>
						<svg:text
							x="{$lx - 98}"
							y="{ 163 + $lx }"
							transform="matrix(0.7,-0.7,0.7,0.7,0,0)"
							style="font-size:8;font-weight:normal;stroke-width:1;font-family:Arial;text-anchor:end;"
							id="LABEL-{position()}"
							xml:space="preserve">
							<svg:tspan
							x="{$lx - 98}"
							y="{ 163 + $lx }"
							id="tspan615-{position()}">
							<xsl:value-of select="choice"/>
							</svg:tspan>
						</svg:text>
				</xsl:for-each>
			<!--End global offset-->						
			</svg:g>
		</svg:svg>
    </xsl:template>
	
	
<xsl:template name="maximum">
	<xsl:param name="param"/>
	<xsl:for-each select="$param">
		<xsl:sort select="votes" data-type="number" order="descending"/>
		<xsl:if test="position() = 1 ">
			<xsl:value-of select="votes"/>
		</xsl:if >
	</xsl:for-each >
</xsl:template>


</xsl:stylesheet> 
