<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>
	
    <xsl:template match="/">
        <div class="roundedbox">
			<xsl:apply-templates />
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div>No commnents</div>
	</xsl:template>
	
	<xsl:key name="threaded-comments" match="row" use="title"/>
	<xsl:key name="threaded-entries" match="row" use="maintitle"/>
	
	<xsl:template match="results">
		<form action="xrl:myblog_update_comments" xrl:resolve="action" method="post">
			<xsl:for-each select="row[count(. | key('threaded-comments', title)[1]) = 1]">
				<div class="blog-comment-title">
					<xsl:value-of select="maintitle"/> : <xsl:value-of select="title"/>
				</div>	
				<xsl:for-each select="key('threaded-comments', title)">
					<div>
						<div class="blog-comment-header">
					On		<span class="blog-date-item"><xsl:value-of select="dateDayName"/></span>
							<span class="blog-date-item"><xsl:value-of select="dateDayOfMonth"/></span>
							<span class="blog-date-item"><xsl:value-of select="dateMonthName"/></span>
							<span class="blog-date-item"><xsl:value-of select="dateYear"/></span>
					at		<xsl:call-template name="addzero">
							<xsl:with-param name="n" select="timeHour"/>
							</xsl:call-template>:<span class="blog-date-item">
							<xsl:call-template name="addzero">
								<xsl:with-param name="n" select="timeMinute"/>
							</xsl:call-template>
							</span>
							
							<span class="blog-comment-author"><xsl:value-of select="author"/></span> commented 
						</div>
						<div class="blog-comment-comment">
							<xsl:copy-of select="comment"/>
						</div>
					</div>
					<label>
					Approve
					<input type="checkbox" name="item">
						<xsl:attribute name="value"><xsl:value-of select="id"/>,pending</xsl:attribute>
						<xsl:if test="status='approved'"><xsl:attribute name="checked">true</xsl:attribute></xsl:if>
					</input>
					</label>
					<label>
					Delete
					<input type="radio" name="item">
						<xsl:attribute name="value"><xsl:value-of select="id"/>,delete</xsl:attribute>
					</input>
					</label>
				</xsl:for-each>		
			</xsl:for-each>
			<br/>
			<input type="submit" value="Submit"/>
		</form>
	</xsl:template>

	<!--Add Zero to a number less than 10-->
	<xsl:template name="addzero">
		<xsl:param name="n"/>
		<xsl:if test="$n &lt; 10">0</xsl:if><xsl:value-of select="$n"/>
	</xsl:template>
	
	
</xsl:stylesheet> 
